/*
 * lxport-a.e.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <e4.h>
#include <er.h>
#include <exerrors.h>
#include <l_list.h>
#include <lxdata.h>
#include <lxlist.h>
#include <lxport-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define lxport(lxport) \
    ((struct lxport_type *) (lxport))

#define xsport(port) \
    ((struct xsport_type *) (port))

#define byte(miss)			((unsigned char *) (miss))

typedef struct land_type {
    int (*push) (void *, const char *, unsigned), rate, text;
    void *data;
} land_type;

static int type_line(void *, int (*) (void *, const char *, unsigned),
		     struct lxport_type *, struct x1f4_dxdata_type *,
		     struct x1f4_dxlist_type *);
static int type_list(void *, void *);

static int
type_line(void *data, int (*push) (void *, const char *, unsigned),
	  struct lxport_type *lxport_data,
	  struct x1f4_dxdata_type *dxdata_data,
	  struct x1f4_dxlist_type *dxlist_data)
{
    int status;

    status = push(data, "`", 1);
    if (status) {
    } else {
	status = push(data, dxdata_data->string, dxdata_data->length);
	if (status) {
	} else {
	    status = push(data, "' of ", 5);
	    if (status) {
	    } else {
		struct land_type land;

		land.data = data;
		land.push = push;
		land.rate = 1;
		land.text = lxport_data->link_i.data;

		status = _libx1f4i0_lime_l4list
		    (dxlist_data->list, &land, type_list);
		if (status) {
		} else {
		    status = push(data, " }", 2);
		}
	    }
	}
    }

    return status;
}


static int
type_list(void *text, void *call)
{
    int (*push) (void *, const char *, unsigned), status;
    struct land_type *land_data;
    void *data;

    land_data = text;

    data = land_data->data;
    push = land_data->push;

    if (land_data->rate) {
	land_data->rate = 0;

	status = push(data, "{ ", 2);
    } else {
	status = push(data, ", ", 2);
    }
    if (status) {
    } else {
	unsigned type;

	type = byte(call)[0] << 030 | byte(call)[1] << 020
	    | byte(call)[2] << 010 | byte(call)[3];
	if (type == X1f4_E4_TEXT) {
	    X1f4_E4_C_TEXT text;

	    text = I_TEXT(byte(call) + 8);

	    status = push(data, "`", 1);
	    if (status) {
	    } else {
		status = push(data, text, strlen(text));
		if (status) {
		} else {
		    status = push(data, "'", 1);
		}
	    }
	} else {
	    if (type == land_data->text) {
		struct x1f4_dxdata_type *dxdata_data;

		dxdata_data = I_DATA(byte(call) + 8);

		status = push(data, "`", 1);
		if (status) {
		} else {
		    status = push
			(data, dxdata_data->string, dxdata_data->length);
		    if (status) {
		    } else {
			status = push(data, "'", 1);
		    }
		}
	    } else {
		status = push(data, "?", 1);
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxport_stat_call(void *lxport, const char *name, unsigned size)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("cannot ", 7);
    PUSH_DATA(name, size);
    PUSH_DATA(": ", 2);
    PUSH_TEXT(strerror(errno));

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


#if 0
int
_libx1f4i0_lxport_stat_fold(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "input file is not readable", 26);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
#endif				/* 0 */


int
_libx1f4i0_lxport_stat_free(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxport_stat_link(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxport_stat_live(void *lxport, void *xsport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("will not execute ", 17);
    PUSH_SUB3(type_line, lxport, xsport(xsport)->path, xsport(xsport)->argv);
    PUSH_DATA(" for previous ", 14);
    PUSH_MODE(xsport(xsport)->waitlink.port);
    PUSH_DATA(" is still running", 17);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxport_stat_mode(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxport_stat_null(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("empty arguments list", 20);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


#if 0
int
_libx1f4i0_lxport_stat_pipe(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "output file is not writable", 27);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
#endif				/* 0 */


int
_libx1f4i0_lxport_stat_push(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("output file is not system writable", 34);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxport_stat_read(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("input file is not system readable", 33);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxport_stat_text(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("non string command argument", 27);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxport_stat_xsxx(void *lxport)
{
    LINE_EEER(lxport(lxport)->link_e);

    PUSH_DATA("failed xshell execution", 23);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
