/*
 * lxport-a.a.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxport-defs.h>
#include <variable.h>

typedef struct constant_type {
    struct x1f4_variable_type variable;
    const void *data;
} constant_type;

static const X1f4_E4_C_MODE modes[] = {
/* *INDENT-OFF* */
    SEND_LOCK,
    READ_LOCK
/* *INDENT-ON* */
};
static const struct constant_type constants[] = {
/* *INDENT-OFF* */
    {	{	"XSHELL_NONBLOCKING_INPUT",
		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	24			},
	modes + 0							},
    {	{	"XSHELL_NONBLOCKING_OUTPUT",
		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	25			},
	modes + 1							}
/* *INDENT-ON* */
};

int
x1f4_vset_lxport(void *lxport, void **context)
{
    int status;
    const struct constant_type *constant_data;
    unsigned i;

    constant_data = constants;

    i = sizeof(constants) / sizeof(struct constant_type);
    for (; i; i--) {
	status = x1f4_push_variable
	    (context, constant_data->variable.name,
	     constant_data->variable.length, constant_data->variable.type,
	     constant_data->variable.flags, (void *) constant_data->data);
	if (status) {
	    break;
	} else {
	    constant_data++;
	}
    }

    return status;
}
