/*
 * lxport-a.1.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxport-defs.h>
#include <lxport-types.h>

static int fini_data(struct lxport_type *);

static int
fini_data(struct lxport_type *lxport_data)
{
    int (*free) (void *, void *), status;
    void *data;

    data = lxport_data->link_w.data;
    free = lxport_data->link_w.free;

    status = free(data, lxport_data->link_f.data);
    if (status) {
	status = FREE_ERROR;
    } else {
	status = free(data, lxport_data);
	if (status) {
	    status = FREE_ERROR;
	}
    }

    return status;
}


int
x1f4_fini_lxport(void **lxport)
{
    return fini_data(*lxport);
}
