/*
 * lxpoll-types.h
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxpoll_types_H__
#define __LIBx1f4_lxpoll_types_H__

#include <config.h>

#include <ct.h>
#include <dt.h>
#include <e4.h>
#include <frame.h>
#include <it.h>
#include <ln.h>
#include <track.h>
#include <trans.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define here_NULL			((void *) 0)

#define here_offsetof(type, ceil) \
    ((integral_q) (&((type *) here_NULL)->ceil))

#define lock_excase(dxpoll_text) \
    ((struct x1f4_nodelink_type *) &lock_cxpoll((dxpoll_text))->link)

#define lock_expoll(dxpoll_text) \
    ((struct x1f4_nodeline_type *) &lock_cxpoll((dxpoll_text))->line)

#define lock_cxpoll(dxpoll_text) \
    ((struct x1f4_leadnode_type *)					      \
     ((char *) (dxpoll_text) - sizeof(struct x1f4_leadnode_type)))

#define near_dxpoll(excase_text) \
    ((struct dxpoll_type *)						      \
     ((char *) near_fxpoll((excase_text)) + sizeof(struct x1f4_leadnode_type)))

#define near_expoll(excase_text) \
    ((struct x1f4_nodeline_type *) &near_fxpoll((excase_text))->line)

#define near_fxpoll(excase_text) \
    ((struct x1f4_leadnode_type *)					      \
     ((char *) (excase_text) - here_offsetof(struct x1f4_leadnode_type, link)))

#define pick_dxpoll(fxpoll_text) \
    ((struct dxpoll_type *)						      \
     ((char *) (fxpoll_text) + sizeof(struct x1f4_leadnode_type)))

#define __struct_dxpoll_type_alloc_size__ \
    sizeof(struct x1f4_leadnode_type) + sizeof(struct dxpoll_type)	      \
    + sizeof(struct x1f4_dispatch_type)

#define d_direct(dxpoll) \
    (((struct dxpoll_type *) (dxpoll))->direct[2])
#define e_direct(dxpoll) \
    (((struct dxpoll_type *) (dxpoll))->direct[1])
#define f_direct(dxpoll) \
    (((struct dxpoll_type *) (dxpoll))->direct[0])

typedef struct dxpoll_type {
    unsigned bits;
    void *device, *direct[3], *ennuie;
} dxpoll_type;

typedef struct lxmiss_type {
    union {
	unsigned miss;
	void *data;
    } data;
} lxmiss_type;

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxpoll_type {
    struct x1f4_track_type link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	void *data, *side, *text;
    } link_f;
    struct {
	int date, file;
    } link_i;
    struct {
	void *date, *file;
    } link_k;
    struct x1f4_trans_type link_m;
    struct x1f4_iturn_type link_p;
    struct x1f4_cturn_type link_q;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } link_r;
    struct {
	struct x1f4_nodetype_type nodetype[1];
    } link_s;
    struct {
	struct x1f4_datatype_type datatype[2];
    } link_t;
    struct x1f4_frame_type link_v;
    struct x1f4_trans_type link_w;
} lxpoll_type;

typedef struct lxtext_type {
    int (*free) (void *, void *, struct x1f4_nodelink_type **,
		 const struct x1f4_nodelink_type *),
	(*land) (void *, void *, struct x1f4_nodelink_type **,
		 const struct x1f4_nodelink_type *),
	(*node) (void *, void **, void *, const struct x1f4_nodelink_type *),
	type;
    void *text;
} lxtext_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	int date, file;
    } link_i;
    struct {
	int type;
    } link_l;
    struct x1f4_trans_type link_m;
    struct x1f4_iturn_type link_p;
    struct x1f4_cturn_type link_q;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } link_r;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct x1f4_frame_type link_v;
    struct x1f4_trans_type link_w;
} screen_type;

#endif				/* __LIBx1f4_lxpoll_types_H__ */
