/*
 * lxpoll-l.w.1.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <e4.h>
#include <lxcast.h>
#include <lxfile.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_w1logique(void *context, void *output, void **input)
{
    int status;
    struct lxpoll_type *lxpoll_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **side;

    side = context;

    lxpoll_data = side[0];

    dxcast_data = I_CAST(input[2]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	int fd = -1;
	struct x1f4_dxfile_type *dxfile_data;

	dxfile_data = I_FILE(input[1]);

	if (dxfile_data->file) {
	    if (dxfile_data->mode == X1f4_LXFILE_READ_CLASS) {
		x1f4_bill_dxfile(dxfile_data, &fd);
	    }
	}

	if (fd == -1) {
	    status = _libx1f4i0_lxpoll_stat_read(lxpoll_data);
	} else {
	    struct dxpoll_type *dxpoll_data;
	    void *node, **pick;

	    dxpoll_data = I_POLL(input[0]);

	    status = _libx1f4i0_lxpoll_node_file
		(lxpoll_data, &node, dxfile_data, dxpoll_data, &pick);
	    if (status) {
	    } else {
		struct x1f4_linetext_type *linetext_text;

		linetext_text = I_USER(&dxcast_data->data);

		status = _libx1f4i0_lxpoll_fast_line
		    (linetext_text, side[1], 3, &input, dxpoll_data,
		     lxpoll_data);
		if (status) {
		    _libx1f4i0_lxpoll_free_file
			(lxpoll_data, node, dxpoll_data);
		} else {
		    int df;
		    struct Mylene101_access_type access;

		    access.fini = _libx1f4i0_lxpoll_flat_line;
		    access.line = _libx1f4i0_lxpoll_fare_line;
		    access.text = input;

		    df = Mylene101_READ_CLASS;

		    input[NODE_LEAD + 0] = node;
		    input[NODE_LEAD + 1] = f_direct(dxpoll_data);
		    input[NODE_LEAD + 2] = lxpoll_data->link_k.file;

		    status = Mylene101_link_access
			(dxpoll_data->device, fd, df, &access, pick);
		    if (status) {
			if (status == Mylene101_EVER_MATCH) {
			    status = _libx1f4i0_lxpoll_stat_ever(lxpoll_data);
			} else {
			    status = _libx1f4i0_lxpoll_stat_poll
				(lxpoll_data, dxpoll_data, status);
			}
		    }

		    if (status) {
			_libx1f4i0_lxpoll_flat_line(NULL, input);
		    }
		}
	    }
	}
    } else {
	status = _libx1f4i0_lxpoll_stat_call(lxpoll_data);
    }

    return status;
}
