/*
 * lxpoll-l.r.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <d_e101.h>
#include <e4.h>
#include <lxfset.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_r_logique(void *context, void *output, void **input)
{
    int status;
    struct dxpoll_type *dxpoll_data;
    void *data, *file;

    dxpoll_data = I_POLL(input[0]);

    file = I_FILE(input[1]);

    status = x1f4_find_lxfset(f_direct(dxpoll_data), &file, &data);
    if (status) {
	struct Mylene101_access_type *access_data;

	access_data = *((void **) data + 1);

	if (Mylene101_case_access(dxpoll_data->device, access_data)
	    == Mylene101_SEND_CLASS) {
	} else {
	    unsigned bits;
	    void **track;

	    track = access_data->text;
	    bits = (integral_q) track[BITS_LEAD];
	    if (bits & LIVE_LINE) {
		track[BITS_LEAD] = (void *) (integral_q) (bits | TRAP_LINE);
	    }
	}

	status = Mylene101_slip_access(dxpoll_data->device, NULL, access_data);
	if (status) {
	    status = _libx1f4i0_lxpoll_stat_poll(context, dxpoll_data, status);
	}
    } else {
	status = _libx1f4i0_lxpoll_stat_miss(context);
    }

    return status;
}
