/*
 * lxpoll-l.q.1.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <e4.h>
#include <lxcast.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_q1logique(void *context, void *output, void **input)
{
    int status;
    struct lxpoll_type *lxpoll_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **side;

    side = context;

    lxpoll_data = side[0];

    dxcast_data = I_CAST(input[2]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	struct dxpoll_type *dxpoll_data;
	void *class[3], **pick;

	dxpoll_data = I_POLL(input[0]);

	status = _libx1f4i0_lxpoll_node_cast
	    (lxpoll_data, class, I_CAST(input[1]), dxpoll_data, &pick);
	if (status) {
	} else {
	    struct x1f4_linetext_type *linetext_text;

	    linetext_text = I_USER(&dxcast_data->data);

	    status = _libx1f4i0_lxpoll_fast_line
		(linetext_text, side[1], 3, &input, dxpoll_data, lxpoll_data);
	    if (status) {
		_libx1f4i0_lxpoll_free_line
		    (lxpoll_data, NULL, class, dxpoll_data);
	    } else {
		struct Mylene101_legend_type legend;

		legend.fini = _libx1f4i0_lxpoll_flat_line;
		legend.fare = _libx1f4i0_lxpoll_fare_line;
		legend.text = input;

		input[NODE_LEAD + 0] = class[0];
		input[NODE_LEAD + 1] = class[1];
		input[NODE_LEAD + 2] = class[2];

		status = Mylene101_push_legend
		    (dxpoll_data->device, &legend, pick);
		if (status) {
		    status = _libx1f4i0_lxpoll_stat_poll
			(lxpoll_data, dxpoll_data, status);

		    _libx1f4i0_lxpoll_flat_line(NULL, input);
		}
	    }
	}
    } else {
	status = _libx1f4i0_lxpoll_stat_call(lxpoll_data);
    }

    return status;
}
