/*
 * lxpoll-l.p.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <e4.h>
#include <lxcall.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))

#define dxpoll(dxpoll) \
    ((struct dxpoll_type *) (dxpoll))

extern const void *const x1f4_a1_walk_link;

static int miss_line(void *);
static int near_call(void *, int, void *, struct x1f4_dispatch_type **);
static int post_call(struct lxpoll_type *, struct dxpoll_type *, void **);

static int
miss_line(void *line)
{
    return _libx1f4i0_lxpoll_flat_line(NULL, line);
}


static int
near_call(void *text, int status, void *output,
	  struct x1f4_dispatch_type **dispatch)
{
    struct dxpoll_type *dxpoll_data;
    unsigned bits;
    void **track;

    track = text;

    dxpoll_data = (void *) *dispatch;
    dxpoll_data--;

    bits = (integral_q) track[BITS_LEAD];
    track[BITS_LEAD] = (void *) (integral_q) (bits & ~LIVE_LINE);

    if (status) {
    } else {
	if (dxpoll_data->bits & POLL_STAYED) {
	    *dispatch = NULL;

	    dxpoll_data->bits &= ~POLL_DEPEND;
	} else {
	    status = post_call
		(track[LINK_LEAD], dxpoll_data, (void *) dispatch);
	}
    }

    return status;
}


static int
post_call(struct lxpoll_type *lxpoll_data, struct dxpoll_type *dxpoll_data,
	  void **dispatch)
{
    int status;
    struct x1f4_dispatch_type *dispatch_data;

    dxpoll_data->bits &= ~POLL_FAILED;

    dispatch_data = (void *) (dxpoll_data + 1);
    dispatch_data->back = (void *) (integral_q) -1;

    status = Mylene101_line_device(dxpoll_data->device, NULL);
    if (status) {
	status = _libx1f4i0_lxpoll_stat_poll(lxpoll_data, dxpoll_data, status);
    } else {
	if (dxpoll_data->bits & POLL_FAILED) {
	    void **track;

	    track = dispatch_data->transfer.input;

	    track[LINK_LEAD] = lxpoll_data;

	    do {
		if (track[NODE_LEAD]) {
		} else {
		    void **mind;

		    status = lxpoll_data->link_v.pick
			(lxpoll_data->link_v.data, &mind, miss_line, 0, NULL);
		    if (status) {
			status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);

			dispatch_data = NULL;

			miss_line(track);

			break;
		    } else {
			*mind = track;
		    }
		}

		dxpoll_data->bits &= ~POLL_STAYED;

		dispatch_data->back = track;
		dispatch_data->call = near_call;
	    } while (0);

	    *dispatch = dispatch_data;
	} else {
	    *dispatch = NULL;

	    dxpoll_data->bits &= ~POLL_DEPEND;
	}
    }

    return status;
}


int
_libx1f4i0_lxpoll_p_logique(void *context, void *output, void **input)
{
    int status;

    if (output == x1f4_a1_walk_link) {
	struct dxpoll_type *dxpoll_data;

	dxpoll_data = I_POLL(((void **) input[1])[0]);

	if (dxpoll_data->bits & POLL_DEPEND) {
	    status = _libx1f4i0_lxpoll_stat_busy(context);
	} else {
	    dxpoll_data->bits |= POLL_DEPEND;

	    dxpoll_data->ennuie =
		((void **) ((void **) input[1])[-1])[X1f4_E4_USED_META];

	    status = post_call(context, dxpoll_data, input + 2);
	}
    } else {
	struct dxpoll_type *dxpoll_data;
	struct x1f4_dispatch_type *dispatch_data;

	dxpoll_data = I_POLL(input[0]);

	if (dxpoll_data->bits & POLL_DEPEND) {
	    status = _libx1f4i0_lxpoll_stat_busy(context);
	} else {
	    dxpoll_data->bits |= POLL_DEPEND;

	    dxpoll_data->ennuie = ((void **) input[-1])[X1f4_E4_USED_META];

	    dispatch_data = (void *) (dxpoll_data + 1);
	    dispatch_data->back = NULL;

	    status = Mylene101_line_device(dxpoll_data->device, NULL);
	    if (status) {
		status =
		    _libx1f4i0_lxpoll_stat_poll(context, dxpoll_data, status);
	    }

	    dxpoll_data->bits &= ~POLL_DEPEND;
	}
    }

    return status;
}
