/*
 * lxpoll-l.e.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <d_e101.h>
#include <e4.h>
#include <lxcast.h>
#include <lxfset.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_e_logique(void *context, void *output, void **input)
{
    int status;
    struct dxpoll_type *dxpoll_data;
    void *data, *user;

    dxpoll_data = I_POLL(input[0]);

    user = I_USER(&((struct x1f4_dxcast_type *) I_CAST(input[1]))->data);

    status = x1f4_find_lxfset(d_direct(dxpoll_data), &user, &data);
    if (status) {
	struct Mylene101_legend_type *legend_data;
	unsigned bits;
	void **track;

	legend_data = *((void **) data + 1);
	track = legend_data->text;
	bits = (integral_q) track[BITS_LEAD];
	if (bits & LIVE_LINE) {
	    track[BITS_LEAD] = (void *) (integral_q) (bits | TRAP_LINE);
	}

	status = Mylene101_slip_legend(dxpoll_data->device, NULL, legend_data);
	if (status) {
	    status = _libx1f4i0_lxpoll_stat_poll(context, dxpoll_data, status);
	}
    } else {
	status = _libx1f4i0_lxpoll_stat_trip(context);
    }

    return status;
}
