/*
 * lxpoll-l.c.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <d_e101.h>
#include <e4.h>
#include <lxfset.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_c_logique(void *context, void *output, void **input)
{
    int status;
    struct dxpoll_type *dxpoll_data;
    void *date, *data;

    dxpoll_data = I_POLL(input[0]);

    date = I_DATE(input[1]);

    status = x1f4_find_lxfset(e_direct(dxpoll_data), &date, &data);
    if (status) {
	struct Mylene101_agenda_type *agenda_data;
	unsigned bits;
	void **track;

	agenda_data = *((void **) data + 1);
	track = agenda_data->text;
	bits = (integral_q) track[BITS_LEAD];
	if (bits & LIVE_LINE) {
	    track[BITS_LEAD] = (void *) (integral_q) (bits | TRAP_LINE);
	}

	status = Mylene101_slip_agenda(dxpoll_data->device, NULL, agenda_data);
	if (status) {
	    status = _libx1f4i0_lxpoll_stat_poll(context, dxpoll_data, status);
	}
    } else {
	status = _libx1f4i0_lxpoll_stat_slip(context);
    }

    return status;
}
