/*
 * lxpoll-i.o.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

static int miss_line(void *);

static int
miss_line(void *line)
{
    int status;
    unsigned bits;
    void **track;

    track = line;

    bits = (integral_q) track[BITS_LEAD];

    if (bits & TRAP_LINE) {
	track[BITS_LEAD] = (void *) (integral_q) 0;
	status = _libx1f4i0_lxpoll_flat_line(NULL, line);
    } else {
	track[BITS_LEAD] = (void *) (integral_q) (bits & ~CALL_LINE);
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxpoll_fare_line(void *method, void *agenda)
{
    int status;

    do {
	unsigned bits;
	void **track;

	track = agenda;

	bits = (integral_q) track[BITS_LEAD];
	if (bits & CALL_LINE) {
	} else {
	    struct lxpoll_type *lxpoll_data;
	    void **mind;

	    lxpoll_data = track[LINK_LEAD];

	    status = lxpoll_data->link_v.pick
		(lxpoll_data->link_v.data, &mind, miss_line, 0, NULL);
	    if (status) {
		status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
		if (1) {
		    break;
		}
	    } else {
		*mind = track;
	    }
	}

	track[BITS_LEAD] = (void *) (integral_q) (CALL_LINE | LIVE_LINE);

	status = _libx1f4i0_lxpoll_fare_date(method, agenda);
    } while (0);

    return status;
}
