/*
 * lxpoll-i.n.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxdate.h>
#include <lxfset.h>
#include <lxpoll-close.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_node_date(struct lxpoll_type *lxpoll_data, void **class,
			    void *date, struct dxpoll_type *dxpoll_data,
			    void ***pick)
{
    int status;

    status = x1f4_node_lxdate
	(lxpoll_data->link_k.date, class, date, lock_excase(dxpoll_data));
    if (status) {
    } else {
	void *record;

	status = x1f4_post_lxfset(e_direct(dxpoll_data), class, &record);
	if (status) {
	    if (status == X1f4_BQFSET_EVER_MATCH) {
		status = _libx1f4i0_lxpoll_stat_data(lxpoll_data);
	    } else {
		status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
	    }

	    x1f4_free_lxdate
		(lxpoll_data->link_k.date, *class, NULL,
		 lock_excase(dxpoll_data));
	} else {
	    void **line;

	    line = record;
	    *line = *class;
	    *pick = line + 1;

	    class[1] = e_direct(dxpoll_data);
	    class[2] = lxpoll_data->link_k.date;
	}
    }

    return status;
}
