/*
 * lxpoll-i.l.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxfset.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

int
_libx1f4i0_lxpoll_free_line(struct lxpoll_type *lxpoll_data,
			    struct x1f4_nodelink_type **nodelink, void **class,
			    struct dxpoll_type *dxpoll_data)
{
    int excess, status;
    struct lxtext_type *lxtext_data;
    void *cast;

    cast = class[0];

    status = _libx1f4i0_cast_lxfset(class[1], &cast);
    if (status) {
	status = _libx1f4i0_lxpoll_stat_free(lxpoll_data);
    } else {
    }

    lxtext_data = class[2];

    if (nodelink) {
	excess = lxtext_data->free
	    (lxtext_data->text, cast, nodelink, lock_excase(dxpoll_data));
    } else {
	excess = lxtext_data->land
	    (lxtext_data->text, cast, NULL, lock_excase(dxpoll_data));
    }
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
