/*
 * lxpoll-i.j.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcall.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

int
_libx1f4i0_lxpoll_fast_line(const struct x1f4_linetext_type *linetext_text,
			    const struct x1f4_function_type *function_data,
			    unsigned offset,
			    void ***class, struct dxpoll_type *dxpoll_data,
			    struct lxpoll_type *lxpoll_data)
{
    int status;
    void **input, **track;

    input = *class;

    track = input + 3;

    status = _libx1f4i0_lxpoll_even_list
	(&linetext_text->function, function_data, offset, &track, lxpoll_data);
    if (status) {
    } else {
	do {
	    struct x1f4_linetext_type *linetext_data;

	    linetext_data = (struct x1f4_linetext_type *) linetext_text;

	    if (linetext_data->function.flags
		& (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
		status = _libx1f4i0_lxcall_lock_call
		    (function_data, offset, &lxpoll_data->link_m,
		     &lxpoll_data->link_e, &linetext_data);
		if (status) {
		    break;
		}
	    }

	    status = _libx1f4i0_lxpoll_type_list
		(linetext_text, &linetext_data->function, track, dxpoll_data,
		 lxpoll_data);
	    if (status) {
	    } else {
		track[DATA_LEAD] = linetext_data;
		track[POLL_LEAD] = dxpoll_data;
		track[LINK_LEAD] = lxpoll_data;
		track[BITS_LEAD] = (void *) (integral_q) 0;
		track[TEXT_LEAD] = (void *) linetext_text;
		track[NODE_LEAD] = NULL;

		*class = track;
	    }

	    if (status) {
		if (linetext_data->function.flags
		    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
		    lxpoll_data->link_m.free
			(lxpoll_data->link_m.data, linetext_data);
		}
	    }
	} while (0);

	if (status) {
	    lxpoll_data->link_m.free
		(lxpoll_data->link_m.data, track - LINE_LEAD);
	}
    }

    return status;
}
