/*
 * lxpoll-i.i.c
 * Copyright (C) 2007-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxpoll_free_text(void *lxpoll, void *text,
			    struct x1f4_nodelink_type **nodetype,
			    const struct x1f4_nodelink_type *nodetype_data)
{
    int status;

    if (text == x1f4_c1_empty_string) {
	status = 0;
    } else {
	status = lxpoll(lxpoll)->link_m.free
	    (lxpoll(lxpoll)->link_m.data, text);
	if (status) {
	    status = _libx1f4i0_lxpoll_stat_free(lxpoll);
	}
    }

    return status;
}
