/*
 * lxpoll-i.h.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcast.h>
#include <lxfset.h>
#include <lxpoll-close.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_node_cast(struct lxpoll_type *lxpoll_data, void **class,
			    void *cast, struct dxpoll_type *dxpoll_data,
			    void ***pick)
{
    int status;

    do {
	int type;
	struct lxtext_type *lxtext_data;
	struct x1f4_dxcast_type *dxcast_data;
	unsigned miss;

	dxcast_data = cast;

	type = dxcast_data->type;

	lxtext_data = lxpoll_data->link_f.text;
	close_frame(miss, lxtext_data);
	if (miss) {
	    if (lxtext_data->land) {
	    } else {
		status = _libx1f4i0_lxpoll_stat_flat(lxpoll_data, type);
		if (1) {
		    break;
		}
	    }
	} else {
	    status = _libx1f4i0_lxpoll_stat_flat(lxpoll_data, type);
	    if (1) {
		break;
	    }
	}

	status = lxtext_data->node
	    (lxtext_data->text, class, I_USER(&dxcast_data->data),
	     lock_excase(dxpoll_data));
	if (status) {
	} else {
	    void *record;

	    status = x1f4_post_lxfset(d_direct(dxpoll_data), class, &record);
	    if (status) {
		if (status == X1f4_BQFSET_EVER_MATCH) {
		    status = _libx1f4i0_lxpoll_stat_data(lxpoll_data);
		} else {
		    status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
		}

		lxtext_data->land
		    (lxtext_data->text, *class, NULL,
		     lock_excase(dxpoll_data));
	    } else {
		void **line;

		line = record;
		*line = *class;
		*pick = line + 1;

		class[1] = d_direct(dxpoll_data);
		class[2] = lxtext_data;
	    }
	}
    } while (0);

    return status;
}
