/*
 * lxpoll-i.g.c
 * Copyright (C) 2007-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

int
_libx1f4i0_lxpoll_node_text(void *lxpoll, void **copy, void *data,
			    const struct x1f4_nodelink_type *nodetype_data)
{
    int status;
    unsigned size;

    size = strlen(data) + 1;
    status = lxpoll(lxpoll)->link_m.link
	(lxpoll(lxpoll)->link_m.data, copy, size);
    if (status) {
	status = _libx1f4i0_lxpoll_stat_link(lxpoll);
    } else {
	memcpy(*copy, data, size);
    }

    return status;
}
