/*
 * lxpoll-i.f.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <exerrors.h>
#include <file.h>
#include <lxfile.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

int
_libx1f4i0_lxpoll_fare_file(void *reflex, void *ennuie)
{
    int excess, status;
    struct lxpoll_type *lxpoll_data;

    lxpoll_data = *((void **) ennuie + 2);

    status = x1f4_long_dxfile
	(lxpoll_data->link_k.file, *(void **) ennuie, &excess);
    if (status) {
    } else {
	if (excess) {
	    if (excess == FILE_OVER_CLASS || excess == FILE_TYPE_CLASS) {
		struct dxpoll_type *dxpoll_data;

		dxpoll_data = *((void **) ennuie + 1);

		status = Mylene101_slip_access
		    (dxpoll_data->device, NULL, *((void **) ennuie + 3));
		if (status) {
		    status = _libx1f4i0_lxpoll_stat_poll
			(lxpoll_data, dxpoll_data, status);
		}

		if (excess == FILE_TYPE_CLASS) {
		    if (status) {
		    } else {
			status = _libx1f4i0_lxpoll_stat_long(lxpoll_data);
		    }
		}
	    } else {
		status = X1f4_EX_CANNOT_CONTINUE;
	    }
	}
    }

    return status;
}
