/*
 * lxpoll-i.d.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <af.h>
#include <e4.h>
#include <fd.h>
#include <lxcall.h>
#include <lxcast.h>
#include <lxlead.h>
#include <lxpoll-close.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>
#include <nl.h>

int
_libx1f4i0_lxpoll_text_list(const struct x1f4_linetext_type *linetext_data,
			    const struct x1f4_function_type *function_data,
			    void **input, struct dxpoll_type *dxpoll_data,
			    struct x1f4_nodelink_type **nodelink,
			    struct lxpoll_type *lxpoll_data)
{
    const int *args;
    int excess, status = 0;
    struct fxdata_type *fxdata_data;
    struct x1f4_nodelink_type *nodelink_data;
    unsigned count;

    if (nodelink) {
	nodelink_data = *nodelink;
    } else {
	nodelink_data = NULL;
    }

    count = function_data->count;

    args = function_data->args;

    fxdata_data = (void *) (input + count);
    for (; count; count--) {
	int type;
	struct lxtext_type *lxtext_data;
	unsigned miss;
	void *call;

	fxdata_data++;

	call = fxdata_data;

	type = *args++;
	if (type == X1f4_E4_CASE) {
	    struct x1f4_dxcast_type *dxcast_data;

	    dxcast_data = *(void **) call;
	    type = dxcast_data->type;
	    call = &dxcast_data->data;
	}

	lxtext_data = lxpoll_data->link_f.text;
	close_frame(miss, lxtext_data);
	if (miss) {
	    if (lxtext_data->free) {
		excess = lxtext_data->free
		    (lxtext_data->text, *(void **) call, &nodelink_data,
		     lock_excase(dxpoll_data));
		if (excess) {
		    status = _libx1f4i0_lxcall_land_slip(excess, status);
		}
	    }
	}
    }

    if (nodelink) {
	*nodelink = nodelink_data;
    } else {
	if (nodelink_data) {
	    excess = x1f4_fail_lxlead(nodelink_data);
	    if (excess) {
		status = _libx1f4i0_lxcall_land_slip(excess, status);
	    }
	}
    }

    excess = _x1f4_free_effect
	(NULL, (void *) linetext_data, nodelink, lock_excase(dxpoll_data));
    if (excess) {
	status = _libx1f4i0_lxcall_land_slip(excess, status);
    }

    return status;
}
