/*
 * lxpoll-i.c.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

int
_libx1f4i0_lxpoll_flat_line(void *method, void *agenda)
{
    int status = 0;
    struct lxpoll_type *lxpoll_data;
    void **track;

    track = agenda;

    lxpoll_data = track[LINK_LEAD];
    if (lxpoll_data) {
	if (track[NODE_LEAD]) {
	    status = _libx1f4i0_lxpoll_free_line
		(lxpoll_data, method, track + NODE_LEAD, track[POLL_LEAD]);
	}

	if ((integral_q) track[BITS_LEAD] & TRAP_LINE) {
	    if (track[NODE_LEAD]) {
		track[NODE_LEAD] = NULL;
	    }
	} else {
	    int excess;
	    struct x1f4_linetext_type *linetext_data;
	    unsigned flags;

	    linetext_data = track[DATA_LEAD];

	    flags = linetext_data->function.flags;

	    excess = _libx1f4i0_lxpoll_text_list
		(track[TEXT_LEAD], &linetext_data->function, track,
		 track[POLL_LEAD], method, lxpoll_data);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }

	    /*
	     * function may be gone by now, flags prerecorded
	     */
	    if (flags & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
		excess = lxpoll_data->link_m.free
		    (lxpoll_data->link_m.data, linetext_data);
		if (excess) {
		    status = _libx1f4i0_lxpoll_stat_free(lxpoll_data);
		}
	    }

	    {
		excess = lxpoll_data->link_m.free
		    (lxpoll_data->link_m.data, track - LINE_LEAD);
		if (excess) {
		    status = _libx1f4i0_lxpoll_stat_free(lxpoll_data);
		}
	    }
	}
    }

    return status;
}
