/*
 * lxpoll-i.b.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <af.h>
#include <e4.h>
#include <fd.h>
#include <lxcast.h>
#include <lxpoll-close.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

int
_libx1f4i0_lxpoll_type_list(const struct x1f4_linetext_type *linetext_data,
			    const struct x1f4_function_type *function_data,
			    void **input, struct dxpoll_type *dxpoll_data,
			    struct lxpoll_type *lxpoll_data)
{
    const int *args;
    int status;

    status = _x1f4_node_effect
	(NULL, (void **) &linetext_data, (void *) linetext_data,
	 lock_excase(dxpoll_data));
    if (status) {
    } else {
	struct fxdata_type *fxdata_data;
	unsigned count;

	args = function_data->args;

	count = function_data->count;

	fxdata_data = (void *) (input + count);
	for (; count; count--) {
	    int type;
	    struct lxtext_type *lxtext_data;
	    unsigned miss;
	    void *call;

	    fxdata_data++;

	    call = fxdata_data;

	    type = *args++;
	    if (type == X1f4_E4_CASE) {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = *(void **) call;
		type = dxcast_data->type;
		call = &dxcast_data->data;
	    }

	    lxtext_data = lxpoll_data->link_f.text;
	    close_frame(miss, lxtext_data);
	    if (miss) {
		if (lxtext_data->node) {
		    status = lxtext_data->node
			(lxtext_data->text, call, *(void **) call,
			 lock_excase(dxpoll_data));
		} else {
		    if (type < X1f4_E4_LAST) {
		    } else {
			status =
			    _libx1f4i0_lxpoll_stat_user(lxpoll_data, type);
		    }
		}
	    } else {
		if (type < X1f4_E4_LAST) {
		} else {
		    status = _libx1f4i0_lxpoll_stat_user(lxpoll_data, type);
		}
	    }
	}

	if (status) {
	    struct x1f4_function_type function;

	    function.args = function_data->args;
	    function.count = function_data->count - count;

	    _libx1f4i0_lxpoll_text_list
		(linetext_data, &function, input, dxpoll_data, NULL,
		 lxpoll_data);
	}
    }

    return status;
}
