/*
 * lxpoll-i.a.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <d_e101.h>
#include <fd.h>
#include <lxcall.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

static int pick_call(void *, void **, struct x1f4_linetext_type *);
static int slip_call(void *, void **, struct x1f4_linetext_type *,
		     struct x1f4_dispatch_type *);

static int
pick_call(void *method, void **track, struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	struct dxpoll_type *dxpoll_data;
	struct fxdata_type missed;
	void **lead, *deftext;

	dxpoll_data = track[POLL_LEAD];

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    void *near;

	    near = dxpoll_data->ennuie;

	    status = linetext_data->function.function
		((void *) linetext_data->context, linetext_data, &near);
	    if (status) {
		break;
	    } else {
		linetext_data->context = near;
	    }
	}

	deftext = (void *) linetext_data->context;

	lead = track + META_LEAD;
	lead[X1f4_E4_USED_META] = dxpoll_data->ennuie;

	track[-1] = lead;

	status = linetext_data->function.function(deftext, &missed, track);

	if (status) {
	} else {
	    if (lead) {
	    } else {
		int excess;

		excess = _libx1f4i0_lxpoll_flat_line(NULL, track);
		if (excess) {
		    status = _libx1f4i0_lxcall_land_slip(excess, status);
		}
	    }
	}
    } while (0);

    return status;
}


/*
 * LINK_LEAD is reset to keep e101 from clearing line
 */
static int
slip_call(void *method, void **track, struct x1f4_linetext_type *linetext_data,
	  struct x1f4_dispatch_type *dispatch_data)
{
    int status;

    do {
	struct dxpoll_type *dxpoll_data;
	void **lead;

	dxpoll_data = track[POLL_LEAD];

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    void *near;

	    near = dxpoll_data->ennuie;

	    status = linetext_data->function.function
		((void *) linetext_data->context, linetext_data, &near);
	    if (status) {
		break;
	    } else {
		linetext_data->context = near;
	    }
	}

	lead = track + META_LEAD;
	lead[X1f4_E4_USED_META] = dxpoll_data->ennuie;

	track[-1] = lead;

	track[LINK_LEAD] = NULL;

	dispatch_data->transfer.context = (void *) linetext_data->context;
	dispatch_data->transfer.function_data = &linetext_data->function;
	dispatch_data->transfer.input = track;
	dispatch_data->transfer.output = (struct fxdata_type *) track[0] - 1;

	status = 0;

	dxpoll_data->bits |= POLL_FAILED;

	Mylene101_fail_device(dxpoll_data->device);
    } while (0);

    return status;
}


int
_libx1f4i0_lxpoll_fare_date(void *method, void *agenda)
{
    int status;
    struct x1f4_dispatch_type *dispatch_data;
    void **track;

    track = agenda;

    dispatch_data = (void *) ((struct dxpoll_type *) track[POLL_LEAD] + 1);
    if (dispatch_data->back) {
	status = slip_call(method, track, track[DATA_LEAD], dispatch_data);
    } else {
	status = pick_call(method, track, track[DATA_LEAD]);
    }

    return status;
}
