/*
 * lxpoll-f.s.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcall.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_POLL(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxpoll_s_forward(void *context, void *output, void **input)
{
    int status;
    struct dxpoll_type *dxpoll_text;
    struct lxpoll_type *lxpoll_data;

    dxpoll_text = I_POLL(input[1]);

    lxpoll_data = context;

    status = _libx1f4i0_lxcall_near_node
	(&lxpoll_data->link_v, &lxpoll_data->link_e,
	 lxpoll_data->link_t.datatype, I_POLL(input[0]));
    if (status) {
    } else {
	lock_expoll(dxpoll_text)->call++;

	l_POLL(dxpoll_text, input[0]);
	l_POLL(dxpoll_text, output);
    }

    return status;
}
