/*
 * lxpoll-f.r.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <e4.h>
#include <lxfile.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_POLL(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxpoll_r_forward(void *context, void *output, void **input)
{
    int status;

    do {
	int df, fd = -1;
	struct dxpoll_type *dxpoll_data;
	struct lxpoll_type *lxpoll_data;
	struct x1f4_dxfile_type *dxfile_data;
	void *data;

	lxpoll_data = context;

	dxfile_data = I_FILE(input[1]);
	if (dxfile_data->file) {
	    if (dxfile_data->mode == X1f4_LXFILE_PUSH_CLASS) {
		x1f4_bill_dxfile(dxfile_data, &fd);
	    }
	}

	if (fd == -1) {
	    status = _libx1f4i0_lxpoll_stat_push(lxpoll_data);
	    if (1) {
		break;
	    }
	}

	dxpoll_data = I_POLL(input[0]);

	df = Mylene101_SEND_CLASS;

	if (Mylene101_find_access(dxpoll_data->device, fd, df, &data)) {
	    status = 0;
	    if (1) {
		break;
	    }
	}

	status = lxpoll_data->link_m.link
	    (lxpoll_data->link_m.data, &data, sizeof(void *) << 2);
	if (status) {
	    status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
	} else {
	    struct Mylene101_access_type access;
	    void *node, **pick;

	    status = _libx1f4i0_lxpoll_node_file
		(lxpoll_data, &node, dxfile_data, dxpoll_data, &pick);
	    if (status) {
	    } else {
		void **line;

		line = data;

		access.fini = _libx1f4i0_lxpoll_flat_file;
		access.line = _libx1f4i0_lxpoll_fare_file;
		access.text = data;

		line[0] = node;
		line[1] = dxpoll_data;
		line[2] = lxpoll_data;

		status = Mylene101_link_access
		    (dxpoll_data->device, fd, df, &access, line + 3);
		if (status) {
		    if (status == Mylene101_EVER_MATCH) {
			status = _libx1f4i0_lxpoll_stat_ever(context);
		    } else {
			status = _libx1f4i0_lxpoll_stat_poll
			    (context, dxpoll_data, status);
		    }
		} else {
		    *pick = line[3];
		}

		if (status) {
		    _libx1f4i0_lxpoll_free_file
			(lxpoll_data, node, dxpoll_data);
		}
	    }

	    if (status) {
		lxpoll_data->link_m.free(lxpoll_data->link_m.data, data);
	    }
	}
    } while (0);

    return status;
}
