/*
 * lxpoll-f.p.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

int
_libx1f4i0_lxpoll_p_forward(void *context, void *data, void **text)
{
    int status;
    struct lxpoll_type *lxpoll_data;
    struct x1f4_function_type *function_data;
    void *near;

    lxpoll_data = context;

    function_data = data;

    function_data->function = _libx1f4i0_lxpoll_p1forward;

    status = lxpoll_data->link_v.link
	(lxpoll_data->link_v.data, &near, sizeof(void *) << 1);
    if (status) {
	status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
    } else {
	void **side;

	side = near;

	*text = side;

	*side = lxpoll_data;
	side[1] = function_data;
    }

    return status;
}
