/*
 * lxpoll-e.n.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <lxfset.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>
#include <tcvset.h>

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

int
_libx1f4i0_lxpoll_fine_poll(void *subtext, void *dxpoll)
{
    int status;
    struct dxpoll_type *dxpoll_data;

    dxpoll_data = dxpoll;
    if (0) {
    } else {
	if (0) {
	} else {
	    int (*call) (void *, struct x1f4_nodelink_type *), excess;
	    unsigned i;

	    status = _libx1f4i0_fini_tcvset
		(&lock_expoll(dxpoll_data)->pset,
		 &lock_expoll(dxpoll_data)->text,
		 (void *) &((struct lxpoll_type *) subtext)->link_m);
	    if (status) {
		status = _libx1f4i0_lxpoll_stat_free(subtext);
	    }

	    call = lxpoll(subtext)->link_r.call;
	    if (call) {
		call(lxpoll(subtext)->link_r.text, lock_excase(dxpoll));
	    }

	    excess = Mylene101_fini_device(&dxpoll_data->device, subtext);
	    if (excess) {
		excess = _libx1f4i0_lxpoll_stat_poll
		    (subtext, dxpoll_data, excess);
		if (status) {
		} else {
		    status = excess;
		}
	    }

	    i = 3;
	    while (i) {
		i--;
		excess = x1f4_fini_lxfset(dxpoll_data->direct + i);
		if (excess) {
		    excess = _libx1f4i0_lxpoll_stat_free(subtext);
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }

	    excess = ((struct lxpoll_type *) subtext)->link_m.free
		(((struct lxpoll_type *) subtext)->link_m.data,
		 lock_cxpoll(dxpoll_data));
	    if (excess) {
		excess = _libx1f4i0_lxpoll_stat_free(subtext);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
