/*
 * lxpoll-e.c.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxlead.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>
#include <nl.h>
#include <tcvset.h>

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_free_lxpoll(void *subtext, void *dxpoll,
		 struct x1f4_nodelink_type **nodelink,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    unsigned call;

    call = lock_expoll(dxpoll)->call;

    /*
     * FEATURES
     *
     * some code will work even without this test, but some will not.  among
     * the one that will not is _long_poll/_near_poll (some reasons recorded
     * there).
     *
     * (old note by now, might be meaningless)
     */
    if (call) {
	call--;
	if (call) {
	    status = tccase(lock_expoll(dxpoll)->text)->miss
		(&lock_expoll(dxpoll)->pset, &lock_expoll(dxpoll)->text,
		 nodelink_data, (void *) &lxpoll(subtext)->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;
	    } else {
		int (*miss) (void *, struct x1f4_nodelink_type **,
			     struct x1f4_nodelink_type *);

		lock_expoll(dxpoll)->call = call;

		miss = lxpoll(subtext)->link_r.miss;
		if (miss) {
		    status = miss
			(lxpoll(subtext)->link_r.text, nodelink,
			 lock_excase(dxpoll));
		} else {
		    status = x1f4_mind_lxlead(nodelink, dxpoll);
		}
	    }
	} else {
	    status = _libx1f4i0_lxpoll_heap_poll(subtext, nodelink, dxpoll);
	}
    } else {
	status = 0;
    }

    return status;
}
