/*
 * lxpoll-defs.h
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxpoll_defs_H__
#define __LIBx1f4_lxpoll_defs_H__

#include <e4.h>

/*
 * device flag definitions
 */
#define POLL_DEPEND			(1L << 0)
#define POLL_FAILED			(1L << 1)
#define POLL_STAYED			(1L << 2)

/*
 * error definitions
 */
#define FREE_ERROR			-2
#define LINK_ERROR			-3
#define MODE_ERROR			-4

/*
 * error definitions (continued)
 */
#define DATE_CLASS			1
#define FILE_CLASS			2

/*
 * generation flag definitions
 */
#define CODELINK_LINK			(1L << 0)
#define COMPOSER_LINK			(1L << 1)
#define EELOOKUP_LINK			(1L << 2)
#define EVERLINK_SLIP			(1L << 3)
#define IMPLICIT_LINK			(1L << 4)
#define MISSBAIL_LINK			(1L << 5)
#define RESOURCE_LINK			(1L << 6)
#define TEXTFLAT_LINK			(1L << 7)

/*
 * line definitions
 */
#define _____LEAD			-1
#define DATA_LEAD			-2
#define POLL_LEAD			-3
#define LINK_LEAD			-4
#define BITS_LEAD			-5
#define TEXT_LEAD			-6
#define NODE_LEAD			(TEXT_LEAD - 3)
#define META_LEAD			(NODE_LEAD - X1f4_E4_USED_SIZE)

/*
 * line definitions (concluded)
 */
#define LINE_LEAD			-META_LEAD

/*
 * track flag definitions
 */
#define CALL_LINE			(1L << 0)
#define LIVE_LINE			(1L << 1)
#define TRAP_LINE			(1L << 2)

#endif				/* __LIBx1f4_lxpoll_defs_H__ */
