/*
 * lxpoll-a.x.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxcall.h>
#include <lxpoll-types.h>
#include <tcvset.h>

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_push_lxpoll(void *lxpoll, void **copy, void *poll,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int status;

    status = tccase(lock_expoll(poll)->text)->miss
	(&lock_expoll(poll)->pset, &lock_expoll(poll)->text, nodelink_data,
	 (void *) &((struct lxpoll_type *) lxpoll)->link_m);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	status = _libx1f4i0_lxcall_near_node
	    (&lxpoll(lxpoll)->link_v, &lxpoll(lxpoll)->link_e,
	     lxpoll(lxpoll)->link_t.datatype, *copy);
	if (status) {
	} else {
	    *copy = (void *) poll;
	}
    }

    return status;
}
