/*
 * lxpoll-a.s.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <d_e101.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define BITS \
    Mylene101_DEVICE_RESOURCE | Mylene101_DEVICE_TEXTFLAT

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

#define dxpoll(poll) \
    ((struct dxpoll_type *) (poll))

int
_libx1f4i0_lxpoll_fast_poll(void *lxpoll, void *dxpoll)
{
    struct Mylene101_device_type device;

    device.resource_set = lxpoll(lxpoll)->link_m;

    device.textflat_set.data = lxpoll(lxpoll)->link_e.data;

    device.textflat_set.line = lxpoll(lxpoll)->link_e.line;
    device.textflat_set.post = lxpoll(lxpoll)->link_e.post;
    device.textflat_set.push = lxpoll(lxpoll)->link_e.push;

    return Mylene101_init_device(&dxpoll(dxpoll)->device, BITS, &device);
}
