/*
 * lxpoll-a.l.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <d_e101.h>
#include <lxcall.h>
#include <lxlead.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>
#include <nl.h>

#define dxpoll(poll) \
    ((struct dxpoll_type *) (poll))

int
_libx1f4i0_lxpoll_null_poll(void *lxpoll, struct x1f4_nodelink_type **nodelink,
			    void *dxpoll)
{
    int status;
    struct x1f4_nodelink_type *nodelink_data;

    if (nodelink) {
	nodelink_data = *nodelink;
    } else {
	nodelink_data = NULL;
    }

    status = Mylene101_high_device(dxpoll(dxpoll)->device, &nodelink_data);
    if (status) {
	status = _libx1f4i0_lxpoll_stat_user(lxpoll, status);
    }

    if (nodelink) {
	*nodelink = nodelink_data;
    } else {
	if (nodelink_data) {
	    int excess;

	    excess = x1f4_fail_lxlead(nodelink_data);
	    if (excess) {
		status = _libx1f4i0_lxcall_land_slip(excess, status);
	    }
	}
    }

    return status;
}
