/*
 * lxpoll-a.g.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxfset.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>
#include <trans.h>
#include <tcvset.h>

#define dxpoll(dxpoll) \
    ((struct dxpoll_type *) (dxpoll))

static int flat_direct(void **, unsigned);
static int line_direct(void **, struct trans_type *);

static int
flat_direct(void **direct, unsigned i)
{
    while (i) {
	i--;
	x1f4_fini_lxfset(direct + i);
    }

    return 0;
}


static int
line_direct(void **direct, struct trans_type *trans_data)
{
    int status;
    unsigned i = 0;

    for (; i < 3; i++) {
	status = x1f4_fare_lxfset(direct + i, trans_data);
	if (status) {
	    break;
	}
    }

    if (status) {
	flat_direct(direct, i);
    }

    return status;
}


int
x1f4_line_lxpoll(void *subtext, void **address)
{
    int status;
    struct lxpoll_type *lxpoll_data;
    void *dxpoll;

    lxpoll_data = subtext;

    status = lxpoll_data->link_m.link
	(lxpoll_data->link_m.data, &dxpoll, __struct_dxpoll_type_alloc_size__);
    if (status) {
	status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
    } else {
	dxpoll = pick_dxpoll(dxpoll);

	status = line_direct(dxpoll(dxpoll)->direct, &lxpoll_data->link_m);
	if (status) {
	    status = _libx1f4i0_lxpoll_stat_link(lxpoll_data);
	} else {
	    status = _libx1f4i0_lxpoll_fast_poll(subtext, dxpoll);
	    if (status) {
		flat_direct(dxpoll(dxpoll)->direct, 3);
	    } else {
		lock_excase(dxpoll)->nodetype_data =
		    lxpoll_data->link_s.nodetype;

		lock_excase(dxpoll)->slip = NULL;

		lock_expoll(dxpoll)->call = 1;

		dxpoll(dxpoll)->bits = 0;

		_libx1f4i0_init_tcvset
		    (&lock_expoll(dxpoll)->pset, &lock_expoll(dxpoll)->text);

		*address = dxpoll;
	    }
	}

	if (status) {
	    lxpoll_data->link_m.free
		(lxpoll_data->link_m.data, lock_cxpoll(dxpoll));
	}
    }

    return status;
}
