/*
 * lxpoll-a.y.c
 * Copyright (C) 2008-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxlead.h>
#include <lxpoll-inter.h>
#include <nt.h>

int
x1f4_type_lxpoll(struct x1f4_nodetype_type *nodetype_data, int cpoll3)
{
    nodetype_data->code = cpoll3;
    nodetype_data->name = "dispatch";
    nodetype_data->size = 8;
    nodetype_data->flags =
	X1f4_LX_LINK_ACCESS | X1f4_LX_PICK_ACCESS | X1f4_LX_TYPE_EXCEPT;

    nodetype_data->call = x1f4_call_lxlead;
    nodetype_data->copy = x1f4_copy_lxpoll;
    nodetype_data->dump = x1f4_dump_lxpoll;
    nodetype_data->free = x1f4_free_lxpoll;
    nodetype_data->hash = x1f4_hash_lxpoll;
    nodetype_data->lead = x1f4_lead_lxpoll;
    nodetype_data->miss = x1f4_near_lxlead;
    nodetype_data->move = x1f4_move_lxpoll;
    nodetype_data->node = x1f4_node_lxpoll;
    nodetype_data->pick = x1f4_pick_lxpoll;
#if 0
    nodetype_data->post = NULL;
#endif				/* 0 */
    nodetype_data->push = x1f4_push_lxpoll;
    nodetype_data->slip = x1f4_slip_lxpoll;

    return 0;
}
