/*
 * lxpoll-a.e.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <d_e101.h>
#include <er.h>
#include <exerrors.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define dxpoll(dxpoll) \
    ((struct dxpoll_type *) (dxpoll))

#define lxpoll(lxpoll) \
    ((struct lxpoll_type *) (lxpoll))

int
_libx1f4i0_lxpoll_stat_busy(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("dispatching already", 19);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_call(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("non function pointer argument", 29);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_data(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("data already registered", 23);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_ever(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("file already registered", 23);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_file(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("file is not system readable/writable", 36);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_flat(void *lxpoll, int type)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_TRAP(type, lxpoll(lxpoll));
    PUSH_DATA(" is not a referable data type", 29);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_free(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxpoll_stat_link(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxpoll_stat_long(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("registered file is not system writable and non blocking", 55);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_miss(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("file not registered", 19);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_poll(void *lxpoll, void *dxpoll, int error)
{
    int status;

    switch (error) {
    case Mylene101_BUSY_ERROR:
	status = X1f4_EX_CAN_CONTINUE;
	break;
    case Mylene101_FARE_ERROR:
    case Mylene101_FINI_ERROR:
    case Mylene101_READ_ERROR:
    case Mylene101_SEND_ERROR:
	status = Mylene101_near_device(dxpoll(dxpoll)->device);
	break;
    case Mylene101_FREE_ERROR:
    case Mylene101_LINK_ERROR:
    case Mylene101_MODE_ERROR:
	status = X1f4_EX_CRITICAL;
	break;
    case Mylene101_POLL_ERROR:
    case Mylene101_EVER_MATCH:
	status = X1f4_EX_CAN_CONTINUE;
	break;
    default:
	status = X1f4_EX_CRITICAL;
    }

    return status;
}


int
_libx1f4i0_lxpoll_stat_push(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("file is not system writable", 27);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_read(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("file is not system readable", 27);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_slip(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("no event scheduled for the date object", 38);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_trip(void *lxpoll)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("no activity registered for the object", 37);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxpoll_stat_user(void *lxpoll, int type)
{
    LINE_EEER(lxpoll(lxpoll)->link_e);

    PUSH_DATA("non referable nor copyable, non intrinsic ", 42);
    PUSH_TRAP(type, lxpoll(lxpoll));
    PUSH_DATA(" used for function parameter", 28);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
