/*
 * lxpoll-a.c.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxlead.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define break_cycles			0

#define lxpoll(poll) \
    ((struct lxpoll_type *) (poll))

int
_libx1f4i0_lxpoll_side_poll(void *subtext, void *dxpoll)
{
    int status;
    unsigned call;

    call = lock_expoll(dxpoll)->call;
    if (call ^ 1) {
	int (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);

	lock_expoll(dxpoll)->call = call - 1;

	miss = lxpoll(subtext)->link_r.miss;
	if (miss) {
	    status =
		miss(lxpoll(subtext)->link_r.text, NULL, lock_excase(dxpoll));
	} else {
	    status = x1f4_mind_lxlead(NULL, dxpoll);
	}
    } else {
	int excess;

	lock_expoll(dxpoll)->call = break_cycles;

	status = _libx1f4i0_lxpoll_null_poll(subtext, NULL, dxpoll);

	excess = _libx1f4i0_lxpoll_fine_poll(subtext, dxpoll);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
