/*
 * lxpoll-a.5.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxpoll-inter.h>
#include <lxpoll-types.h>

#define dxpoll(poll) \
    ((struct dxpoll_type *) (poll))

int
x1f4_flat_lxpoll(void *subtext, void **address)
{
    int status;
    void *poll;

    poll = *address;
    if (!poll) {
	status = 0;
    } else {
	status = _libx1f4i0_lxpoll_side_poll(subtext, poll);
	if (0) {
	} else {
	    /*
	     * at the very least, _side_lx attempted to destroy the object
	     */
	    *address = NULL;
	}
    }

    return status;
}
