/*
 * lxpoll-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <af.h>
#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxpoll-defs.h>
#include <lxpoll-inter.h>
#include <lxpoll-types.h>

/*
 * NOTES
 *
 * not using the implicit convertion mechanics now, as the latter (usually)
 * create temporaries.  as they are still not strictly required.
 */

/*
 * TODO
 *
 *.improve on _data_ readers by not freeing the existing buffer.  it can be
 * achieved by messing with the memory allocator.
 *
 */

#define MAKE_SINGLE(a, b)		a

#define FFLAGS_KT			X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK
#define FFLAGS_KPT \
    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK
#define FFLAGS_KST \
    X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST | X1f4_E4_TEXT_LINK
#define FFLAGS_KTW \
    X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK | X1f4_E4_WALK_LINK

#define fb_size()			1

#define screen(screen) \
    ((struct screen_type *) (screen))

extern const struct x1f4_eelookup_type _x1f4_type_lookup;

static int init_poll(struct lxpoll_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxpoll_type *, unsigned,
		     const struct screen_type *, void *);
static int line_poll(struct lxpoll_type *, unsigned,
		     const struct screen_type *);
static int line_text(struct lxpoll_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_poll(struct lxpoll_type *, unsigned,
		     const struct screen_type *);

static void line_cfix(u_case_args_____0);
static void line_efix(u_case_args_____0);
static void line_pfix(u_case_args_____0);
static void line_pset(u_case_args_____0);
static void line_qfix(u_case_args_____0);
static void line_rfix(u_case_args_____0);
static void line_rset(u_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_smap(u_case_args_____0);
static void line_sset(u_case_args_____0);
static void line_wfix(u_case_args_____0);

static const char fw_setf[] = "w_set", *const side_f[] = {
/* *INDENT-OFF* */
    fw_setf
/* *INDENT-ON* */
};
static const struct line_type ever_line[] = {
/* *INDENT-OFF* */
#define l_set_count			2
    {	{	fw_setf,
		_libx1f4i0_lxpoll_s_forward,	0,
		NULL,				l_set_count,
		FFLAGS_KPT,			5		},
	line_sset,							}
#define l_set_reach			(0 + (l_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			l_set_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define l_cancel_count			2
    {	{	"w_cancel",
		_libx1f4i0_lxpoll_c_logique,	X1f4_E4_VOID,
		NULL,				l_cancel_count,
		FFLAGS_KT,			8		},
	line_cfix,							},
#define l_cancel_reach			(0 + l_cancel_count)
#define l_expire_count			2
    {	{	"w_expire",
		_libx1f4i0_lxpoll_e_logique,	X1f4_E4_VOID,
		NULL,				l_expire_count,
		FFLAGS_KT,			8		},
	line_efix,							},
#define l_expire_reach			(l_cancel_reach + l_expire_count)
#define l_press_count			1
    {	{	"w_press",
		_libx1f4i0_lxpoll_p_logique,	X1f4_E4_VOID,
		NULL,				l_press_count,
		FFLAGS_KTW,			7		},
	line_pfix,							},
#define l_press_reach			(l_expire_reach + l_press_count)
#define l_program_count			3
    {	{	"w_program",
		_libx1f4i0_lxpoll_p_forward,	X1f4_E4_VOID,
		NULL,				l_program_count,
		FFLAGS_KST,			9		},
	line_pset,							},
#define l_program_reach			(l_press_reach + l_program_count)
#define l_queue_count			3
    {	{	"w_queue",
		_libx1f4i0_lxpoll_q_logique,	X1f4_E4_VOID,
		NULL,				l_queue_count,
		FFLAGS_KST,			7		},
	line_qfix,							},
#define l_queue_reach			(l_program_reach + l_queue_count)
#define l_register_count		2
    {	{	"w_register",
		_libx1f4i0_lxpoll_r_forward,	X1f4_E4_VOID,
		NULL,				l_register_count,
		FFLAGS_KT,			10		},
	line_rset,							},
#define l_register_reach		(l_queue_reach + l_register_count)
#define l_resign_count			2
    {	{	"w_resign",
		_libx1f4i0_lxpoll_r_logique,	X1f4_E4_VOID,
		NULL,				l_resign_count,
		FFLAGS_KT,			8		},
	line_rfix,							},
#define l_resign_reach			(l_register_reach + l_resign_count)
#define l_schedule_count		3
    {	{	"w_schedule",
		_libx1f4i0_lxpoll_s_logique,	X1f4_E4_VOID,
		NULL,				l_schedule_count,
		FFLAGS_KST,			10		},
	line_sfix,							},
#define l_schedule_reach		(l_resign_reach + l_schedule_count)
#define l_suspend_count			1
    {	{	"w_suspend",
		_libx1f4i0_lxpoll_s_pending,	X1f4_E4_VOID,
		NULL,				l_suspend_count,
		X1f4_E4_KEEP_CALL,		9		},
	line_smap,							},
#define l_suspend_reach			(l_schedule_reach + l_suspend_count)
#define l_watch_count			3
    {	{	"w_watch",
		_libx1f4i0_lxpoll_w_logique,	X1f4_E4_VOID,
		NULL,				l_watch_count,
		FFLAGS_KST,			7		},
	line_wfix,							}
#define l_watch_reach			(l_suspend_reach + l_watch_count)
/* *INDENT-ON* */
#define slip_line_count			l_watch_reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_poll(struct lxpoll_type *lxpoll_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    if (1) {
	lxpoll_data->link_v.data = screen_data->link_v.data;
	lxpoll_data->link_v.free = screen_data->link_v.free;
	lxpoll_data->link_v.link = screen_data->link_v.link;
	lxpoll_data->link_v.mode = screen_data->link_v.mode;
	lxpoll_data->link_v.pick = screen_data->link_v.pick;
	lxpoll_data->link_v.slip = screen_data->link_v.slip;
    } else {
	bits &= ~EVERLINK_SLIP;

	lxpoll_data->link_v.data = NULL;
	lxpoll_data->link_v.free = NULL;
	lxpoll_data->link_v.link = NULL;
	lxpoll_data->link_v.mode = NULL;
	lxpoll_data->link_v.pick = NULL;
	lxpoll_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxpoll_data->link_w.data = screen_data->link_w.data;
	lxpoll_data->link_w.free = screen_data->link_w.free;
	lxpoll_data->link_w.link = screen_data->link_w.link;
	lxpoll_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxpoll_data->link_w.data = NULL;
	lxpoll_data->link_w.free = _x1f4_e4_free_data;
	lxpoll_data->link_w.link = _x1f4_e4_link_data;
	lxpoll_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & MISSBAIL_LINK) {
	lxpoll_data->link_r.call = screen_data->link_r.call;
	lxpoll_data->link_r.fine = screen_data->link_r.fine;
	lxpoll_data->link_r.miss = screen_data->link_r.miss;
	lxpoll_data->link_r.text = screen_data->link_r.text;
    } else {
	lxpoll_data->link_r.call = NULL;
	lxpoll_data->link_r.fine = NULL;
	lxpoll_data->link_r.miss = NULL;
    }

    if (bits & IMPLICIT_LINK) {
	lxpoll_data->link_p.link = screen_data->link_p.link;
	lxpoll_data->link_p.text = screen_data->link_p.text;
    } else {
	lxpoll_data->link_p.link = NULL;
	lxpoll_data->link_p.text = NULL;
    }

    if (bits & COMPOSER_LINK) {
	lxpoll_data->link_q.link = screen_data->link_q.link;
	lxpoll_data->link_q.text = screen_data->link_q.text;
    } else {
	lxpoll_data->link_q.link = NULL;
	lxpoll_data->link_q.text = NULL;
    }

    if (bits & RESOURCE_LINK) {
	lxpoll_data->link_m.data = screen_data->link_m.data;
	lxpoll_data->link_m.free = screen_data->link_m.free;
	lxpoll_data->link_m.link = screen_data->link_m.link;
	lxpoll_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxpoll_data->link_m.data = NULL;
	lxpoll_data->link_m.free = _x1f4_e4_free_data;
	lxpoll_data->link_m.link = _x1f4_e4_link_data;
	lxpoll_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxpoll_data->link_e.data = screen_data->link_e.data;
	lxpoll_data->link_e.line = screen_data->link_e.line;
	lxpoll_data->link_e.post = screen_data->link_e.post;
	lxpoll_data->link_e.push = screen_data->link_e.push;
    } else {
	lxpoll_data->link_e.data = NULL;
	lxpoll_data->link_e.line = NULL;
	lxpoll_data->link_e.post = NULL;
	lxpoll_data->link_e.push = NULL;
    }

    if (bits & EELOOKUP_LINK) {
	lxpoll_data->trap_e.eelookup_data = screen_data->trap_e.eelookup_data;
    } else {
	lxpoll_data->trap_e.eelookup_data = &_x1f4_type_lookup;
    }

    return link_poll(lxpoll_data, bits, screen_data);
}


static int
line_data(struct lxpoll_type *lxpoll_data, unsigned bits,
	  const struct screen_type *screen_data, void *text)
{
    int date, file, status;
    struct lxtext_type *lxtext_data;
    const struct x1f4_nodetype_type *nodetype_data;
    unsigned i;

    nodetype_data = screen_data->link_t.data;

    date = screen_data->link_i.date;
    file = screen_data->link_i.file;

    lxpoll_data->link_k.date = NULL;
    lxpoll_data->link_k.file = NULL;

    lxtext_data = text;

    lxtext_data->free = _x1f4_free_effect;
    lxtext_data->land = NULL;
    lxtext_data->node = _x1f4_node_effect;

    lxtext_data++;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	int code;

	code = nodetype_data->code;

	lxtext_data->type = code;
	if (code == X1f4_E4_TEXT) {
	    lxtext_data->free = _libx1f4i0_lxpoll_free_text;
	    lxtext_data->land = NULL;
	    lxtext_data->node = _libx1f4i0_lxpoll_node_text;
	    lxtext_data->text = lxpoll_data;
	} else {
	    if (nodetype_data->flags & X1f4_LX_LINK_ACCESS) {
		lxtext_data->free = nodetype_data->free;
		lxtext_data->land = nodetype_data->free;
		lxtext_data->node = nodetype_data->node;
		if (nodetype_data->flags & X1f4_LX_PICK_ACCESS) {
		    lxtext_data->free = nodetype_data->pick;
		}
	    } else {
		lxtext_data->free = NULL;
		lxtext_data->land = NULL;
		lxtext_data->node = NULL;
	    }

	    if (code == date) {
		lxpoll_data->link_k.date = lxtext_data;
	    } else {
		if (code == file) {
		    lxpoll_data->link_k.file = lxtext_data;
		}
	    }
	}

	lxtext_data++;

	nodetype_data++;
    }

    if (lxpoll_data->link_k.file) {
	if (lxpoll_data->link_k.date) {
	    status = 0;
	} else {
	    status = DATE_CLASS;
	}
    } else {
	status = FILE_CLASS;
    }

    return status;
}


static int
line_poll(struct lxpoll_type *lxpoll_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxpoll_data->link_t.datatype[0].context = lxpoll_data;

    lxpoll_data->link_t.datatype[0].flat = _libx1f4i0_lxpoll_flat_poll;
    lxpoll_data->link_t.datatype[0].lead = _libx1f4i0_lxpoll_lead_poll;
    lxpoll_data->link_t.datatype[0].line = _libx1f4i0_lxpoll_line_poll;
    lxpoll_data->link_t.datatype[0].link = _libx1f4i0_lxpoll_link_poll;
    lxpoll_data->link_t.datatype[0].name = "dispatch";
    lxpoll_data->link_t.datatype[0].shut = _libx1f4i0_lxpoll_flat_poll;
    lxpoll_data->link_t.datatype[0].slip = _libx1f4i0_lxpoll_slip_poll;
    lxpoll_data->link_t.datatype[0].size = 8;
    lxpoll_data->link_t.datatype[0].type = screen_data->link_l.type;

    lxpoll_data->link_s.nodetype[0].context = lxpoll_data;

    _libx1f4i0_lxpoll_type_poll
	(lxpoll_data->link_s.nodetype + 0, screen_data->link_l.type);

    lxpoll_data->link_t.datatype[1].context = NULL;

    lxpoll_data->link_t.datatype[1].flat = NULL;
    lxpoll_data->link_t.datatype[1].lead = NULL;
    lxpoll_data->link_t.datatype[1].line = NULL;
    lxpoll_data->link_t.datatype[1].link = NULL;
    lxpoll_data->link_t.datatype[1].name = NULL;
    lxpoll_data->link_t.datatype[1].shut = NULL;
    lxpoll_data->link_t.datatype[1].slip = NULL;
    lxpoll_data->link_t.datatype[1].size = 0;
    lxpoll_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_text(struct lxpoll_type *lxpoll_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxpoll_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxpoll_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_poll(struct lxpoll_type *lxpoll_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count, line_count, miss;
    void *data;

    args_count = 0;
    line_count = 1;

    miss = screen_data->link_t.miss;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }

    status = lxpoll_data->link_w.link
	(lxpoll_data->link_w.data, &data,
	 sizeof(struct lxtext_type) * (1 + miss) + args_count * sizeof(int)
	 + line_count * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *)
	 + sizeof(struct lxmiss_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side, *text;

	text = (struct x1f4_linetext_type *) data + line_count;
	text = (struct lxmiss_type *) text + 1;
	side = (struct lxtext_type *) text + miss + 1;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;

	lxpoll_data->link_f.data = data;
	lxpoll_data->link_f.side = side;
	lxpoll_data->link_f.text = text;

	((struct lxmiss_type *) text - 1)->data.miss = miss;

	status = line_data(lxpoll_data, bits, screen_data, text);
	if (status) {
	    lxpoll_data->link_w.free(lxpoll_data->link_w.data, data);
	} else {
	    line_text(lxpoll_data, bits, screen_data, data, &args, &dana);
	    _libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	    line_poll(lxpoll_data, bits, screen_data);
	}
    }

    return status;
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.date;

    *args = line;
}


static void
line_efix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_pfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.date;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_qfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_CASE;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_rfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.file;

    *args = line;
}


static void
line_rset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.file;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.date;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_smap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_wfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.file;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


int
x1f4_init_lxpoll(void **lxpoll, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *file, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &file, sizeof(struct lxpoll_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_poll(file, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, file);
	    } else {
		_x1f4_e4_free_data(text, file);
	    }
	} else {
	    *lxpoll = file;
	}
    }

    return status;
}
