/*
 * lxnear.h
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxnear_H__
#define __LIBx1f4_lxnear_H__

#include <lxnote.h>
#include <trans.h>

/*
 * error definitions
 */
#define X1f4_LXNEAR_FREE_ERROR		-2
#define X1f4_LXNEAR_LINK_ERROR		-3
#define X1f4_LXNEAR_MODE_ERROR		-4

/*
 * generation flag definitions
 */
#define X1f4_LXNEAR_CODELINK		(1L << 0)
#define X1f4_LXNEAR_LONGPIPE		(1L << 1)
#define X1f4_LXNEAR_TEXTFLAT		(1L << 2)
#define X1f4_LXNEAR_TRANSFER		(1L << 3)

typedef struct x1f4_datapipe_type {
    const char *name;
    int (*copy) (void *, const char *, unsigned), type;
    unsigned size;
    void *text;
} x1f4_datapipe_type;

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

typedef struct x1f4_textpipe_type {
    const char *name;
    int (*copy) (void *, const char *, unsigned);
    unsigned size;
    void *text;
} x1f4_textpipe_type;

typedef struct x1f4_lxnear_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_textpipe_type *textpipe_data;
    } nearpipe_set;
    struct {
	unsigned miss;
	const struct x1f4_datapipe_type *datapipe_data;
    } longpipe_set;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } autolink_set;
    struct x1f4_trans_type codelink_set;
} x1f4_lxnear_type;

extern int x1f4_dfix_lxnear(void *, unsigned, void *);
extern int x1f4_fini_lxnear(void **);
extern int x1f4_fset_lxnear(void *, const struct x1f4_linetext_type **);
extern int x1f4_init_lxnear
    (void **, unsigned, const struct x1f4_lxnear_type *);
extern int x1f4_note_lxnear(const struct x1f4_lxnote_type **);

#endif				/* __LIBx1f4_lxnear_H__ */
