/*
 * lxnear-types.h
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxnear_types_H__
#define __LIBx1f4_lxnear_types_H__

#include <config.h>

#include <e4.h>
#include <frame.h>
#include <track.h>

typedef struct lxdata_type {
    const char *name;
    int (*copy) (void *, const char *, unsigned), type;
    unsigned size;
    void *text;
} lxdata_type;

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxnear_type {
    struct x1f4_track_type link_e;
    struct {
	void *data, *text;
    } link_f;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxnear_type;

typedef struct lxtext_type {
    int (*push) (void *, const char *, unsigned);
    unsigned bits;
    void *data, *lead[2], *text;
} lxtext_type;

typedef struct lxtype_type {
    const char *name;
    int (*copy) (void *, const char *, unsigned);
    unsigned size;
    void *text;
} lxtype_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct {
	void *fine;
    } link_o;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct {
	unsigned miss;
	const void *data;
    } link_u;
    struct x1f4_frame_type link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxnear_types_H__ */
