/*
 * lxnear-p.w.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <e4.h>
#if !defined HAVE_LIBx1f4i0
# include <float.v-pw.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxnear-defs.h>
#include <lxnear-inter.h>
#include <lxnear-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxnear_w_pending(void *context, void *output, void **input)
{
    int status;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    if (lxtext_data->bits & TYPED_TEXT) {
	lxtext_data->lead[1] = I_USER(input[0]);
	input++;
    }

    do {
	X1f4_E4_C_MODE P, p, w;
	int a;

	P = I_MODE(input[1]);

	p = I_MODE(input[2]);

	w = I_MODE(input[0]);

	if (P < 0 || p < 0) {
	    status = _libx1f4i0_lxnear_near_fill(lxtext_data, w);
	    if (1) {
		break;
	    }
	}

	if (w < 0) {
	    w = -w;
	    a = 1;
	} else {
	    a = 0;
	}

	status = x1f4_vprint_pwfloat
	    (lxtext_data->data, lxtext_data->push, a, w, P, p,
	     I_REAL(input[3]));
    } while (0);

    return status;
}
