/*
 * lxnear-l.p.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <lxnear-inter.h>
#include <lxnear-types.h>

int
_libx1f4i0_lxnear_p_logique(void *context, void *data, void **text)
{
    int status;
    struct lxtext_type *lxtext_data;
    struct lxnear_type *lxnear_data;
    struct x1f4_function_type *function_data;
    void *near;

    lxtext_data = context;

    lxnear_data = lxtext_data->text;

    function_data = data;

    function_data->function = _libx1f4i0_lxnear_p1logique;

    status = lxnear_data->link_v.link
	(lxnear_data->link_v.data, &near, sizeof(void *) << 1);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	void **side;

	side = near;

	*text = side;

	*side = lxtext_data;
	side[1] = function_data;
    }

    return status;
}
