/*
 * lxnear-l.p.1.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <e4.h>
#if !defined HAVE_LIBx1f4i0
# include <float.v.h>
# include <lcardinal.v-d.h>
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxcast.h>
#include <lxnear-defs.h>
#include <lxnear-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxnear_p1logique(void *context, void *output, void **input)
{
    const int *args;
    int status = 0;
    struct x1f4_function_type *function_data;
    struct lxtext_type *lxtext_data;
    unsigned count;
    void **side;

    side = context;

    lxtext_data = *side;

    function_data = side[1];

    args = function_data->args;

    count = function_data->count;

    if (lxtext_data->bits & TYPED_TEXT) {
	lxtext_data->lead[1] = I_USER(input[0]);
	args++;
	input++;
	count--;
    }

    if (count) {
	X1f4_E4_C_TEXT line;
	int (*push) (void *, const char *, unsigned);
	void *data;

	data = lxtext_data->data;
	push = lxtext_data->push;

	do {
	    int type;
	    void *call;

	    call = *input++;

	    type = *args++;
	    if (type == X1f4_E4_CASE) {
		struct x1f4_dxcast_type *object_data;

		object_data = I_USER(call);
		call = &object_data->data;
		type = object_data->type;
	    }

	    switch (type) {
	    case X1f4_E4_BILL:
		status = x1f4_vprint_dlcardinal(data, push, I_BILL(call));
		break;
	    case X1f4_E4_MODE:
		status = x1f4_vprint_dlintegral(data, push, I_MODE(call));
		break;
	    case X1f4_E4_REAL:
		status = x1f4_vprint_float(data, push, 077, I_REAL(call));
		break;
	    case X1f4_E4_TEXT:
		line = I_TEXT(call);
		status = push(data, line, strlen(line));
	    }

	    if (status) {
		break;
	    }

	    count--;
	} while (count);
    }

    return status;
}
