/*
 * lxnear-f.b.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <e4.h>
#if !defined HAVE_LIBx1f4i0
# include <lintegral.v-fb.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxnear-defs.h>
#include <lxnear-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxnear_b_forward(void *context, void *output, void **input)
{
    int status;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    if (lxtext_data->bits & TYPED_TEXT) {
	lxtext_data->lead[1] = I_USER(input[0]);
	input++;
    }

    do {
	X1f4_E4_C_MODE b, f, x;

	b = I_MODE(input[0]);
	if (b < 0) {
	    status = 0;
	    if (1) {
		break;
	    }
	}

	f = I_MODE(input[1]);
	if (f < 0) {
	    status = 0;
	    if (1) {
		break;
	    }
	}

	x = I_MODE(input[2]);
	if (x < 2) {
	    status = 0;
	    if (1) {
		break;
	    }
	} else {
	    if (36 < x) {
		status = 0;
		if (1) {
		    break;
		}
	    }
	}

	status = x1f4_vprint_fblintegral
	    (lxtext_data->data, lxtext_data->push, 0, f, b, x,
	     I_MODE(input[3]));
    } while (0);

    return status;
}
