/*
 * lxnear-a.e.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <er.h>
#include <exerrors.h>
#include <lxnear-types.h>

#define lxnear(lxnear) \
    ((struct lxnear_type *) (lxnear))

int
_libx1f4i0_lxnear_stat_flat(void *lxnear, int news)
{
    LINE_EEER(lxnear(lxnear)->link_e);

    PUSH_DATA("bad type for argument corresponding `%", 38);
    PUSH_BYTE(news);
    PUSH_DATA("' (`cardinal', `integer' or `real' expected)", 44);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_lock(void *lxnear, unsigned lock, unsigned class)
{
    LINE_EEER(lxnear(lxnear)->link_e);

    PUSH_DATA("item index in format specification (", 36);
    PUSH_BILL(lock);
    PUSH_DATA(") outside range ( .. ", 21);
    PUSH_BILL(class - 1);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_news(void *lxnear, int news)
{
    LINE_EEER(lxnear(lxnear)->link_e);

    PUSH_DATA("unrecognized formatting directive `", 35);
    PUSH_BYTE(news);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_post(void *lxnear)
{
    LINE_EEER(lxnear(lxnear)->link_e);

    PUSH_DATA("unmatched leading `/'", 21);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_text(void *lxnear)
{
    LINE_EEER(lxnear(lxnear)->link_e);

    PUSH_DATA("bad type for argument corresponding `%s' (`text' expected)",
	      58);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
