/*
 * lxnear-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <e4fine.h>
#include <lxcall.h>
#include <lxnear-defs.h>
#include <lxnear-inter.h>
#include <lxnear-types.h>

#define ft_size(miss) \
    ((miss) * sizeof(struct lxtext_type))

typedef struct miss_type {
    struct x1f4_function_type function;
} miss_type;

static int init_near(struct lxnear_type *, unsigned,
		     const struct screen_type *);
static int line_call(struct lxnear_type *, unsigned,
		     const struct screen_type *, void **, void **, void **,
		     void **);
static int line_miss(struct lxnear_type *, unsigned,
		     const struct screen_type *, void **, void **, void **,
		     void **);
static int line_zero(struct lxnear_type *, void **);
static int link_near(struct lxnear_type *, unsigned,
		     const struct screen_type *);
static int pick_call(unsigned *, unsigned *, unsigned *, unsigned,
		     const struct screen_type *);
static int pick_miss(unsigned *, unsigned *, unsigned *, unsigned,
		     const struct screen_type *);

static void side_call(void *, unsigned, const struct screen_type *,
		      struct x1f4_linetext_type *, const struct lxdata_type *,
		      void **, void **, unsigned, const struct miss_type *);
static void side_miss(void *, unsigned, const struct screen_type *,
		      struct x1f4_linetext_type *, const struct lxtype_type *,
		      void **, unsigned, const struct miss_type *);

static const int red_b____[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL
/* *INDENT-ON* */
}, red_m_3_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_BILL
/* *INDENT-ON* */
}, red_m_3_r[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_REAL
/* *INDENT-ON* */
}, red_m_4__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, red_m_4_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_BILL
/* *INDENT-ON* */
}, red_m_5__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, red_m____[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE
/* *INDENT-ON* */
}, red_m_b__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_BILL
/* *INDENT-ON* */
}, red_m_m_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_BILL
/* *INDENT-ON* */
}, red_m_m__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, red_m_m_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, red_m_r__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_REAL
/* *INDENT-ON* */
}, red_t____[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT
/* *INDENT-ON* */
};
static const struct miss_type fast_line[] = {
/* *INDENT-OFF* */
#define l_bfxcardinal_class		12
#define l_bfxcardinal_count		4
    {	{	"_bfxcardinal",
		_libx1f4i0_lxnear_b_pending,	X1f4_E4_VOID,
		red_m_3_b,			l_bfxcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_bfxcardinal_class	},	},
#define l_bfxcardinal_reach		(0 + l_bfxcardinal_count)
#define l_bfxcardinal_trans		(0 + l_bfxcardinal_class)
#define l_bfxinteger_class		11
#define l_bfxinteger_count		4
    {	{	"_bfxinteger",
		_libx1f4i0_lxnear_b_forward,	X1f4_E4_VOID,
		red_m_4__,			l_bfxinteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_bfxinteger_class	},	},
#define l_bfxinteger_reach \
    (l_bfxcardinal_reach + l_bfxinteger_count)
#define l_bfxinteger_trans \
    (l_bfxcardinal_trans + l_bfxinteger_class)
#define l_byte_class			5
#define l_byte_count			1
    {	{	"_byte",
		_libx1f4i0_lxnear_b_logique,	X1f4_E4_VOID,
		red_m____,			l_byte_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_byte_class		},	},
#define l_byte_reach			(l_bfxinteger_reach + l_byte_count)
#define l_byte_trans			(l_bfxinteger_trans + l_byte_class)
#define l_cardinal_class		9
#define l_cardinal_count		1
    {	{	"_cardinal",
		_libx1f4i0_lxnear_c_logique,	X1f4_E4_VOID,
		red_b____,			l_cardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_cardinal_class	},	},
#define l_cardinal_reach		(l_byte_reach + l_cardinal_count)
#define l_cardinal_trans		(l_byte_trans + l_cardinal_class)
#define l_etext_class			6
#define l_etext_count			1
    {	{	"_etext",
		_libx1f4i0_lxnear_e_logique,	X1f4_E4_VOID,
		red_t____,			l_etext_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_etext_class	},	},
#define l_etext_reach			(l_cardinal_reach + l_etext_count)
#define l_etext_trans			(l_cardinal_trans + l_etext_class)
#define l_fcardinal_class		10
#define l_fcardinal_count		2
    {	{	"_fcardinal",
		_libx1f4i0_lxnear_f_sequent,	X1f4_E4_VOID,
		red_m_b__,			l_fcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_fcardinal_class	},	},
#define l_fcardinal_reach		(l_etext_reach + l_fcardinal_count)
#define l_fcardinal_trans		(l_etext_trans + l_fcardinal_class)
#define l_finteger_class		9
#define l_finteger_count		2
    {	{	"_finteger",
		_libx1f4i0_lxnear_f_derived,	X1f4_E4_VOID,
		red_m_m__,			l_finteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_finteger_class	},	},
#define l_finteger_reach		(l_fcardinal_reach + l_finteger_count)
#define l_finteger_trans		(l_fcardinal_trans + l_finteger_class)
#define l_form_class			5
#define l_form_count			1
    {	{	"_form",
		_libx1f4i0_lxnear_f_pending,	X1f4_E4_VOID,
		red_t____,			l_form_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
					l_form_class		},	},
#define l_form_reach			(l_finteger_reach + l_form_count)
#define l_form_trans			(l_finteger_trans + l_form_class)
#define l_fxcardinal_class		11
#define l_fxcardinal_count		3
    {	{	"_fxcardinal",
		_libx1f4i0_lxnear_f_forward,	X1f4_E4_VOID,
		red_m_m_b,			l_fxcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_fxcardinal_class	},	},
#define l_fxcardinal_reach		(l_form_reach + l_fxcardinal_count)
#define l_fxcardinal_trans		(l_form_trans + l_fxcardinal_class)
#define l_fxinteger_class		10
#define l_fxinteger_count		3
    {	{	"_fxinteger",
		_libx1f4i0_lxnear_f_logique,	X1f4_E4_VOID,
		red_m_m_m,			l_fxinteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_fxinteger_class	},	},
#define l_fxinteger_reach \
    (l_fxcardinal_reach + l_fxinteger_count)
#define l_fxinteger_trans \
    (l_fxcardinal_trans + l_fxinteger_class)
#define l_integer_class			8
#define l_integer_count			1
    {	{	"_integer",
		_libx1f4i0_lxnear_i_logique,	X1f4_E4_VOID,
		red_m____,			l_integer_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_integer_class		},	},
#define l_integer_reach			(l_fxinteger_reach + l_integer_count)
#define l_integer_trans			(l_fxinteger_trans + l_integer_class)
#define l_newline_class			8
#define l_newline_count			0
    {	{	"_newline",
		_libx1f4i0_lxnear_n_logique,	X1f4_E4_VOID,
		NULL,				l_newline_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_newline_class		},	},
#define l_newline_reach			(l_integer_reach + l_newline_count)
#define l_newline_trans			(l_integer_trans + l_newline_class)
#define l_plan_class			5
#define l_plan_count			0
    {	{	"_plan",
		_libx1f4i0_lxnear_p_logique,	X1f4_E4_VOID,
		NULL,				l_plan_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
					l_plan_class		},	},
#define l_plan_reach			(l_newline_reach + l_plan_count)
#define l_plan_trans			(l_newline_trans + l_plan_class)
#define l_real_class			5
#define l_real_count			2
    {	{	"_real",
		_libx1f4i0_lxnear_r_logique,	X1f4_E4_VOID,
		red_m_r__,			l_real_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_real_class	},	},
#define l_real_reach			(l_plan_reach + l_real_count)
#define l_real_trans			(l_plan_trans + l_real_class)
#define l_space_class			6
#define l_space_count			1
    {	{	"_space",
		_libx1f4i0_lxnear_s_logique,	X1f4_E4_VOID,
		red_m____,			l_space_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_space_class	},	},
#define l_space_reach			(l_real_reach + l_space_count)
#define l_space_trans			(l_real_trans + l_space_class)
#define l_text_class			5
#define l_text_count			1
    {	{	"_text",
		_libx1f4i0_lxnear_t_logique,	X1f4_E4_VOID,
		red_t____,			l_text_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_text_class	},	},
#define l_text_reach			(l_space_reach + l_text_count)
#define l_text_trans			(l_space_trans + l_text_class)
#define l_wbfxcardinal_class		13
#define l_wbfxcardinal_count		5
    {	{	"_wbfxcardinal",
		_libx1f4i0_lxnear_w_derived,	X1f4_E4_VOID,
		red_m_4_b,			l_wbfxcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_wbfxcardinal_class	},	},
#define l_wbfxcardinal_reach		(l_text_reach + l_wbfxcardinal_count)
#define l_wbfxcardinal_trans		(l_text_trans + l_wbfxcardinal_class)
#define l_wbfxinteger_class		12
#define l_wbfxinteger_count		5
    {	{	"_wbfxinteger",
		_libx1f4i0_lxnear_w_logique,	X1f4_E4_VOID,
		red_m_5__,			l_wbfxinteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_wbfxinteger_class	},	},
#define l_wbfxinteger_reach \
    (l_wbfxcardinal_reach + l_wbfxinteger_count)
#define l_wbfxinteger_trans \
    (l_wbfxcardinal_trans + l_wbfxinteger_class)
#define l_wcardinal_class		10
#define l_wcardinal_count		2
    {	{	"_wcardinal",
		_libx1f4i0_lxnear_w_sequent,	X1f4_E4_VOID,
		red_m_b__,			l_wcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_wcardinal_class	},	},
#define l_wcardinal_reach \
    (l_wbfxinteger_reach + l_wcardinal_count)
#define l_wcardinal_trans \
    (l_wbfxinteger_trans + l_wcardinal_class)
#define l_winteger_class		9
#define l_winteger_count		2
    {	{	"_winteger",
		_libx1f4i0_lxnear_w_forward,	X1f4_E4_VOID,
		red_m_m__,			l_winteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_winteger_class	},	},
#define l_winteger_reach		(l_wcardinal_reach + l_winteger_count)
#define l_winteger_trans		(l_wcardinal_trans + l_winteger_class)
#define l_wpreal_class			7
#define l_wpreal_count			4
    {	{	"_wpreal",
		_libx1f4i0_lxnear_w_pending,	X1f4_E4_VOID,
		red_m_3_r,			l_wpreal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_wpreal_class	},	},
#define l_wpreal_reach			(l_winteger_reach + l_wpreal_count)
#define l_wpreal_trans			(l_winteger_trans + l_wpreal_class)
#define l_wxcardinal_class		11
#define l_wxcardinal_count		3
    {	{	"_wxcardinal",
		_libx1f4i0_lxnear_w_centric,	X1f4_E4_VOID,
		red_m_m_b,			l_wxcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_wxcardinal_class	},	},
#define l_wxcardinal_reach		(l_wpreal_reach + l_wxcardinal_count)
#define l_wxcardinal_trans		(l_wpreal_trans + l_wxcardinal_class)
#define l_wxinteger_class		10
#define l_wxinteger_count		3
    {	{	"_wxinteger",
		_libx1f4i0_lxnear_w_nearest,	X1f4_E4_VOID,
		red_m_m_m,			l_wxinteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_wxinteger_class	},	},
#define l_wxinteger_reach \
    (l_wxcardinal_reach + l_wxinteger_count)
#define l_wxinteger_trans \
    (l_wxcardinal_trans + l_wxinteger_class)
#define l_xcardinal_class		10
#define l_xcardinal_count		2
    {	{	"_xcardinal",
		_libx1f4i0_lxnear_x_forward,	X1f4_E4_VOID,
		red_m_b__,			l_xcardinal_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_xcardinal_class	},	},
#define l_xcardinal_reach		(l_wxinteger_reach + l_xcardinal_count)
#define l_xcardinal_trans		(l_wxinteger_trans + l_xcardinal_class)
#define l_xinteger_class		9
#define l_xinteger_count		2
    {	{	"_xinteger",
		_libx1f4i0_lxnear_x_logique,	X1f4_E4_VOID,
		red_m_m__,			l_xinteger_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					l_xinteger_class	},	}
#define l_xinteger_reach		(l_xcardinal_reach + l_xinteger_count)
#define l_xinteger_trans		(l_xcardinal_trans + l_xinteger_class)
/* *INDENT-ON* */
#define fast_line_class			l_xinteger_trans
#define fast_line_count			l_xinteger_reach
};

static int
init_near(struct lxnear_type *lxnear_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxnear_data->link_w.data = screen_data->link_w.data;
	lxnear_data->link_w.free = screen_data->link_w.free;
	lxnear_data->link_w.link = screen_data->link_w.link;
	lxnear_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxnear_data->link_w.data = NULL;
	lxnear_data->link_w.free = _x1f4_e4_free_data;
	lxnear_data->link_w.link = _x1f4_e4_link_data;
	lxnear_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (1) {
	lxnear_data->link_v.data = screen_data->link_v.data;
	lxnear_data->link_v.link = screen_data->link_v.link;
    }

    if (bits & TEXTFLAT_LINK) {
	lxnear_data->link_e.data = screen_data->link_e.data;
	lxnear_data->link_e.line = screen_data->link_e.line;
	lxnear_data->link_e.post = screen_data->link_e.post;
	lxnear_data->link_e.push = screen_data->link_e.push;
    } else {
	lxnear_data->link_e.data = NULL;
	lxnear_data->link_e.line = NULL;
	lxnear_data->link_e.post = NULL;
	lxnear_data->link_e.push = NULL;
    }

    status = link_near(lxnear_data, bits, screen_data);

    return status;
}


static int
line_call(struct lxnear_type *lxnear_data, unsigned bits,
	  const struct screen_type *screen_data, void **data, void **text,
	  void **args, void **dana)
{
    struct lxtext_type *lxtext_data;
    const struct lxdata_type *lxdata_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    lxdata_data = screen_data->link_u.data;

    linetext_data = *data;
    lxtext_data = *text;

    i = screen_data->link_u.miss;
    for (; i; i--) {
	lxtext_data->bits = TYPED_TEXT;

	lxtext_data->data = lxtext_data->lead;
	lxtext_data->push = lxdata_data->copy;
	lxtext_data->text = lxnear_data;

	lxtext_data->lead[0] = lxdata_data->text;

	side_call
	    (lxtext_data, bits, screen_data, linetext_data, lxdata_data, args,
	     dana, sizeof(fast_line) / sizeof(struct miss_type), fast_line);
	linetext_data += sizeof(fast_line) / sizeof(struct miss_type);

	lxtext_data++;

	lxdata_data++;
    }

    *text = lxtext_data;
    *data = linetext_data;

    return 0;
}


static int
line_miss(struct lxnear_type *lxnear_data, unsigned bits,
	  const struct screen_type *screen_data, void **data, void **text,
	  void **args, void **dana)
{
    struct lxtext_type *lxtext_data;
    const struct lxtype_type *lxtype_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    lxtype_data = screen_data->link_t.data;

    linetext_data = *data;
    lxtext_data = *text;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	lxtext_data->bits = 0;

	lxtext_data->data = lxtype_data->text;
	lxtext_data->push = lxtype_data->copy;
	lxtext_data->text = lxnear_data;

	side_miss
	    (lxtext_data, bits, screen_data, linetext_data, lxtype_data, dana,
	     sizeof(fast_line) / sizeof(struct miss_type), fast_line);
	linetext_data += sizeof(fast_line) / sizeof(struct miss_type);

	lxtext_data++;

	lxtype_data++;
    }

    *text = lxtext_data;
    *data = linetext_data;

    return 0;
}


static int
line_zero(struct lxnear_type *lxnear_data, void **data)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = *data;

    _libx1f4i0_lxcall_zero_line(linetext_data);

    *data = linetext_data + 1;

    return 0;
}


static int
link_near(struct lxnear_type *lxnear_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count, call, line_count, main_count, miss;
    void *data;

    miss = screen_data->link_t.miss;
    if (bits & LONGPIPE_LINK) {
	call = screen_data->link_u.miss;
    } else {
	call = 0;
    }

    pick_miss(&args_count, &line_count, &main_count, bits, screen_data);
    if (call) {
	pick_call(&args_count, &line_count, &main_count, bits, screen_data);
    }

    status = lxnear_data->link_w.link
	(lxnear_data->link_w.data, &data,
	 ft_size(call + miss) + args_count * sizeof(int)
	 + line_count * sizeof(struct x1f4_linetext_type) + main_count);
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *text;

	text = (struct x1f4_linetext_type *) data + line_count;
	args = (struct lxtext_type *) text + call + miss;
	dana = (int *) args + args_count;

	lxnear_data->link_f.data = data;
	lxnear_data->link_f.text = (struct lxtext_type *) text + miss;

	line_miss(lxnear_data, bits, screen_data, &data, &text, &args, &dana);
	if (call) {
	    line_call
		(lxnear_data, bits, screen_data, &data, &text, &args, &dana);
	}
	line_zero(lxnear_data, &data);

	if (status) {
	    lxnear_data->link_w.free(lxnear_data->link_w.data, data);
	} else {
	}
    }

    return status;
}


static int
pick_call(unsigned *args, unsigned *line, unsigned *pick, unsigned bits,
	  const struct screen_type *screen_data)
{
    const struct lxdata_type *lxdata_data;
    unsigned args_count, line_count, i, main_count;

    lxdata_data = screen_data->link_u.data;

    args_count = *args;
    line_count = *line;
    main_count = *pick;

    i = screen_data->link_u.miss;
    for (; i; i--) {
	unsigned deck;

	deck = lxdata_data->size + 1;

	args_count += fast_line_count;
	args_count += sizeof(fast_line) / sizeof(struct miss_type);
	line_count += sizeof(fast_line) / sizeof(struct miss_type);
	main_count += deck * sizeof(fast_line) / sizeof(struct miss_type)
	    + fast_line_class;

	lxdata_data++;
    }

    *args = args_count;
    *line = line_count;
    *pick = main_count;

    return 0;
}


static int
pick_miss(unsigned *args, unsigned *line, unsigned *pick, unsigned bits,
	  const struct screen_type *screen_data)
{
    const struct lxtype_type *lxtype_data;
    unsigned line_count = 1, i, main_count = 0;

    lxtype_data = screen_data->link_t.data;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	unsigned deck;

	deck = lxtype_data->size + 1;

	line_count += sizeof(fast_line) / sizeof(struct miss_type);
	main_count += deck * sizeof(fast_line) / sizeof(struct miss_type)
	    + fast_line_class;

	lxtype_data++;
    }

    *args = 0;
    *line = line_count;
    *pick = main_count;

    return 0;
}


static void
side_call(void *context, unsigned bits, const struct screen_type *screen_data,
	  struct x1f4_linetext_type *linetext_data,
	  const struct lxdata_type *lxdata_data, void **line, void **dana,
	  unsigned count, const struct miss_type *line_data)
{
    const char *name;
    char *text;
    int *args, type;
    unsigned size;

    size = lxdata_data->size;

    name = lxdata_data->name;

    type = lxdata_data->type;

    args = *line;

    text = *dana;

    while (count) {
	unsigned call, fail;

	linetext_data->context = context;

	linetext_data->function = line_data->function;

	fail = line_data->function.length;

	linetext_data->function.length = size + fail;

	linetext_data->function.name = text;

	linetext_data->function.args = args;

	call = line_data->function.count;

	linetext_data->function.count = call + 1;

	*args++ = type;
	memcpy(args, line_data->function.args, call * sizeof(int));

	args += call;

	fail++;

	memcpy(text, name, size);
	text += size;
	memcpy(text, line_data->function.name, fail);

	text += fail;

	linetext_data++;

	line_data++;

	count--;
    }

    *dana = text;

    *line = args;
}


static void
side_miss(void *context, unsigned bits, const struct screen_type *screen_data,
	  struct x1f4_linetext_type *linetext_data,
	  const struct lxtype_type *lxtype_data, void **dana,
	  unsigned count, const struct miss_type *line_data)
{
    const char *name;
    char *text;
    unsigned size;

    size = lxtype_data->size;

    name = lxtype_data->name;

    text = *dana;

    while (count) {
	unsigned fail;

	linetext_data->context = context;

	linetext_data->function = line_data->function;

	fail = line_data->function.length;

	linetext_data->function.length = size + fail;

	linetext_data->function.name = text;

	fail++;

	memcpy(text, name, size);
	text += size;
	memcpy(text, line_data->function.name, fail);

	text += fail;

	linetext_data++;

	line_data++;

	count--;
    }

    *dana = text;
}


int
x1f4_init_lxnear(void **lxnear, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *near, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &near, sizeof(struct lxnear_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_near(near, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, near);
	    } else {
		_x1f4_e4_free_data(text, near);
	    }
	} else {
	    *lxnear = near;
	}
    }

    return status;
}
