/*
 * lxmath-e.k.c
 * Copyright (C) 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxmath-defs.h>
#include <lxmath-inter.h>
#include <lxmath-types.h>
#include <lxwide.h>

int
x1f4_tile_lxmath(void **lxmath, unsigned bits,
		 struct x1f4_lxwide_type *lxwide_data, unsigned tile,
		 const void *data)
{
    int status;
    struct screen_type screen;
    unsigned flags;

    if (data) {
	screen = *(const struct screen_type *) data;
    }

    flags = tile;

    if (bits & X1f4_LXWIDE_CODELINK) {
	if (flags & CODELINK_LINK) {
	} else {
	    flags |= CODELINK_LINK;
	    screen.link_w.data = lxwide_data->codelink_set.data;
	    screen.link_w.free = lxwide_data->codelink_set.free;
	    screen.link_w.link = lxwide_data->codelink_set.link;
	    screen.link_w.mode = lxwide_data->codelink_set.mode;
	}
    }

    if (bits & X1f4_LXWIDE_TEXTFLAT) {
	if (flags & TEXTFLAT_LINK) {
	} else {
	    flags |= TEXTFLAT_LINK;
	    screen.link_e.data = lxwide_data->textflat_set.data;
	    screen.link_e.line = lxwide_data->textflat_set.line;
	    screen.link_e.post = lxwide_data->textflat_set.post;
	    screen.link_e.push = lxwide_data->textflat_set.push;
	}
    }

    status = _libx1f4i0_lxmath_init_math(lxmath, flags, &screen);
    if (status) {
    } else {
    }

    return status;
}
