/*
 * lxmath-a.e.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <er.h>
#include <exerrors.h>
#include <lxmath-types.h>

#define lxmath(lxmath) \
    ((struct lxmath_type *) (lxmath))

int
_libx1f4i0_lxmath_stat_clip(void *lxmath, double tear, double call)
{
    LINE_EEER(lxmath(lxmath)->link_e);

    PUSH_DATA("invalid clip range (", 20);
    PUSH_REAL(16, tear);
    PUSH_DATA(" .. ", 4);
    PUSH_REAL(16, call);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_head(void *lxmath, long tear, long call)
{
    LINE_EEER(lxmath(lxmath)->link_e);

    PUSH_DATA("invalid clip range (", 20);
    PUSH_LONG(tear);
    PUSH_DATA(" .. ", 4);
    PUSH_LONG(call);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_real(void *lxmath, const char *call, double dieu)
{
    LINE_EEER(lxmath(lxmath)->link_e);

    PUSH_DATA("domain error for `", 18);
    PUSH_TEXT(call);
    PUSH_DATA("' argument, value was ", 22);
    PUSH_REAL(16, dieu);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_spin(void *lxmath, const char *call, double beta,
			    double fail)
{
    LINE_EEER(lxmath(lxmath)->link_e);

    PUSH_DATA("domain error for `", 18);
    PUSH_TEXT(call);
    PUSH_DATA("' arguments, values were ", 25);
    PUSH_REAL(16, beta);
    PUSH_DATA(", ", 2);
    PUSH_REAL(16, fail);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_zero(void *lxmath)
{
    LINE_EEER(lxmath(lxmath)->link_e);

    PUSH_DATA("division by zero", 16);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
