/*
 * lxlist.h
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxlist_H__
#define __LIBx1f4_lxlist_H__

#include <dt.h>
#include <e4.h>
#include <nl.h>
#include <nt.h>
#include <trans.h>

/*
 * error definitions
 */
#define X1f4_LXLIST_DECK_ERROR		-1
#define X1f4_LXLIST_FREE_ERROR		-2
#define X1f4_LXLIST_LINK_ERROR		-3
#define X1f4_LXLIST_MODE_ERROR		-4

/*
 * generation flag definitions
 */
#define X1f4_LXLIST_AUTOLINK		(1L << 0)
#define X1f4_LXLIST_CASTTYPE		(1L << 1)
#define X1f4_LXLIST_CODELINK		(1L << 2)
#define X1f4_LXLIST_EELOOKUP		(1L << 3)
#define X1f4_LXLIST_EVERLINK		(1L << 4)
#define X1f4_LXLIST_MISSBAIL		(1L << 5)
#define X1f4_LXLIST_RESETNEW		(1L << 6)
#define X1f4_LXLIST_RESOURCE		(1L << 7)
#define X1f4_LXLIST_TEXTFLAT		(1L << 8)
#define X1f4_LXLIST_TRANSFER		(1L << 9)

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

typedef struct x1f4_dxlist_type {
    unsigned size;
    void *list;
} x1f4_dxlist_type;

typedef struct x1f4_lxlist_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } listtype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct x1f4_trans_type codelink_set;
} x1f4_lxlist_type;

extern int x1f4_cfix_lxlist(void *, unsigned, void *);
extern int x1f4_copy_lxlist
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_dset_lxlist(void *, const struct x1f4_datatype_type **);
extern int x1f4_fare_lxlist
    (void *, void *, void **, const void *, const struct x1f4_nodelink_type *);
extern int x1f4_fini_lxlist(void **);
extern int x1f4_flat_lxlist(void *, void **);
extern int x1f4_free_lxlist
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_fset_lxlist(void *, const struct x1f4_linetext_type **);
extern int x1f4_init_lxlist
    (void **, unsigned, const struct x1f4_lxlist_type *);
extern int x1f4_lead_lxlist
    (void *, void **);
extern int x1f4_move_lxlist
    (void *, void *, const struct x1f4_nodelink_type *,
     const struct x1f4_nodelink_type *);
extern int x1f4_node_lxlist
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_post_lxlist
    (void *, void **, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxlist
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_slip_lxlist
    (void *, void **);
extern int x1f4_text_lxlist(void *, unsigned, void *);
extern int x1f4_type_lxlist
    (struct x1f4_nodetype_type *, int);

#endif				/* __LIBx1f4_lxlist_H__ */
