/*
 * lxlist-v.h.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_list.h>
#include <lxcall.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_h_class_v(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    lxlist_data = lxtext_data->text;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	if (!dxlist_data->size) {
	    status = _libx1f4i0_lxlist_stat_null(lxlist_data);
	} else {
	    void *data;

	    status = _libx1f4i0_lead_l4list(dxlist_data->list, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != lxtext_data->lxtype.code) {
		    status = _libx1f4i0_lxlist_stat_type
			(lxlist_data, 0, type, lxtext_data->lxtype.code);
		} else {
		    status = _libx1f4i0_lxcall_pick_node
			(&lxlist_data->link_v, &lxlist_data->link_e,
			 &lxtext_data->lxtype, I_USER(byte(data) + 8), output);
		}
	    }
	}
    }

    return status;
}
