/*
 * lxlist-u.e.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#if __CLIP_EXTRACT__
# define clip(none) \
    ((struct clip_type *) (none))
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
typedef struct clip_type {
    unsigned type;
    void *output;
} clip_type;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
static int clip_miss(void *, void *);
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
static int
clip_miss(void *clip, void *data)
{
    int status;
    unsigned type;

    type = byte(data)[0] << 030 | byte(data)[1] << 020 | byte(data)[2] << 010
	| byte(data)[3];
    if (type ^ clip(clip)->type) {
	clip(clip)->type = type;

	status = 1;
    } else {
	status = 0;

	l_USER(I_USER(byte(data) + 8), clip(clip)->output);
    }

    return status;
}
#endif				/* __CLIP_EXTRACT__ */


int
_libx1f4i0_lxlist_e_class_u(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    dxlist_data = I_LIST(input[1]);
    if (0) {
    } else {
	X1f4_E4_C_MODE mode;
	unsigned size;

	mode = I_MODE(input[2]);

	size = dxlist_data->size;
	if (mode < -(X1f4_E4_C_MODE) (int) size
	    || !(mode < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(lxtext_data->text, size, mode);
	} else {
#if __CLIP_EXTRACT__
	    struct clip_type clip;
#else
	    void *data;
#endif				/* __CLIP_EXTRACT__ */

	    if (mode < 0) {
		mode += size;
	    }

#if __CLIP_EXTRACT__
	    clip.output = input[0];
	    clip.type = lxtext_data->lxtype.code;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
	    status = _libx1f4i0_pull_l4list
		(dxlist_data->list, mode, &clip, clip_miss);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_call
		    (lxtext_data->text, mode, clip.type,
		     lxtext_data->lxtype.code, status);
	    } else {
		dxlist_data->size = size - 1;
	    }
#else
	    status = _libx1f4i0_peek_l4list(dxlist_data->list, mode, &data);
	    if (status) {
		status =
		    _libx1f4i0_lxlist_stat_list(lxtext_data->text, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != lxtext_data->lxtype.code) {
		    status = _libx1f4i0_lxlist_stat_type
			(lxtext_data->text, mode, type,
			 lxtext_data->lxtype.code);
		} else {
		    X1f4_E4_C_USER fast;

		    fast = I_USER(byte(data) + 8);

		    status = _libx1f4i0_miss_l4list(dxlist_data->list, mode);
		    if (status) {
			status = _libx1f4i0_lxlist_stat_list
			    (lxtext_data->text, status);
		    } else {
			dxlist_data->size = size - 1;

			l_USER(fast, input[0]);
		    }
		}
	    }
#endif				/* __CLIP_EXTRACT__ */
	}
    }

    return status;
}
